/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.jsyn.SynthDataQueue;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.Module;
import com.softsynth.wire.QueuedDataModule;
import com.softsynth.wire.SynthWireJack;
import com.softsynth.wire.WireJack;
import java.io.IOException;

class SynthQueueWireJack
extends SynthWireJack {
    public SynthQueueWireJack(Module module, String name, SynthPort port) {
        super(module, name, port);
    }

    @Override
    void setup() {
        this.setMaxConnected(Integer.MAX_VALUE);
    }

    public void clear(int time) {
        SynthDataQueue dataQueue = (SynthDataQueue)this.port;
        if (this.port != null) {
            dataQueue.clear(time);
        }
    }

    public void queue(int time, SynthChannelData data, int startFrame, int numFrames) {
        SynthDataQueue dataQueue = (SynthDataQueue)this.port;
        if (this.port != null) {
            dataQueue.queue(time, data, startFrame, numFrames);
        }
    }

    public void queueLoop(int time, SynthChannelData data, int startFrame, int numFrames) {
        SynthDataQueue dataQueue = (SynthDataQueue)this.port;
        if (this.port != null) {
            dataQueue.queueLoop(time, data, startFrame, numFrames);
        }
    }

    public void queueOn(int time, SynthChannelData data) {
        SynthDataQueue dataQueue = (SynthDataQueue)this.port;
        if (this.port != null) {
            dataQueue.queueOn(time, data);
        }
    }

    public void queueOff(int time, SynthChannelData data) {
        SynthDataQueue dataQueue = (SynthDataQueue)this.port;
        if (this.port != null) {
            dataQueue.queueOff(time, data);
        }
    }

    @Override
    void generateSource(IndentingWriter writer, int phase) throws IOException {
        switch (phase) {
            case 5: {
                int i = 0;
                while (i < this.getConnectedCount()) {
                    WireJack connected = this.getConnected(i);
                    Module connectedModule = connected.getModule();
                    if (connectedModule instanceof QueuedDataModule) {
                        QueuedDataModule queuedModule = (QueuedDataModule)connectedModule;
                        writer.println(String.valueOf(this.getSourceName()) + ".clear( time );");
                        if (queuedModule.getAutoStop() && queuedModule.getChannelData().getSustainBegin() < 0 && queuedModule.getChannelData().getReleaseBegin() < 0) {
                            writer.println(String.valueOf(this.getSourceName()) + ".queue( time, " + connectedModule.getName() + ", 0, " + connectedModule.getName() + ".getNumFrames()" + ", Synth.FLAG_AUTO_STOP );");
                        } else {
                            writer.println(String.valueOf(this.getSourceName()) + ".queueOn( time, " + connectedModule.getName() + " );");
                        }
                    }
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < this.getConnectedCount()) {
                    WireJack connected = this.getConnected(i);
                    Module connectedModule = connected.getModule();
                    if (connectedModule instanceof QueuedDataModule) {
                        QueuedDataModule queuedModule = (QueuedDataModule)connectedModule;
                        if (queuedModule.getAutoStop()) {
                            writer.println(String.valueOf(this.getSourceName()) + ".queueOff( time, " + connectedModule.getName() + ", true );");
                        } else {
                            writer.println(String.valueOf(this.getSourceName()) + ".queueOff( time, " + connectedModule.getName() + " );");
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

