/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.jsyn.util.WAVFileWriter;
import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.AlertUser;
import com.softsynth.wire.LabelledCanvas;
import com.softsynth.wire.Module;
import com.softsynth.wire.OutputSetJack;
import com.softsynth.wire.QueuedDataModule;
import com.softsynth.wire.SampleDialog;
import com.softsynth.wire.SaveAsStream;
import com.softsynth.wire.Wire;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

class SampleModule
extends QueuedDataModule {
    SynthSample sample;
    File file = null;
    SampleDialog sampleDialog;
    OutputSetJack f2rJack;

    SampleModule() {
    }

    @Override
    public void setupJacks() {
        super.setupJacks();
        LabelledCanvas outCan = new LabelledCanvas("f2r");
        this.f2rJack = new OutputSetJack((Module)this, outCan, "f2r");
        this.addJackCanvas(this.f2rJack);
        outCan.setWireJack(this.f2rJack);
        this.outJack.getComponent().setBackground(Wire.SAMPQUEUE_PORT_COLOR);
        this.outJack.setSupportMask(this.outJack.getSupportMask() | 8);
        this.sampleDialog = new SampleDialog(this.patch.getPatchPanel().getFrame(), this, null);
    }

    public void saveToFile() {
        try {
            String fileName = "saved_sample.wav";
            RandomAccessFile rfile = new RandomAccessFile("saved_sample.wav", "rw");
            WAVFileWriter wavWriter = new WAVFileWriter(rfile);
            int numSamples = this.sample.getNumFrames() * this.sample.getChannelsPerFrame();
            short[] data = new short[numSamples];
            this.sample.read(data);
            wavWriter.write(data, this.sample.getChannelsPerFrame(), (int)Synth.getFrameRate());
            wavWriter.close();
            System.out.println("Wrote saved_sample.wav");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    @Override
    public Rectangle getEditorBounds() {
        return this.sampleDialog.getBounds();
    }

    @Override
    public void setEditorBounds(Rectangle rect) {
        this.sampleDialog.setBounds(rect);
    }

    @Override
    public void calculateSize() {
        this.panel.setSize(70, 126);
    }

    @Override
    void saveContentToStream(SaveAsStream stream) throws IOException {
        super.saveContentToStream(stream);
        if (this.file != null) {
            stream.writeFileName(this.file.getPath());
        } else {
            stream.writeSampleFormat(this.sample.getNumFrames(), this.sample.getChannelsPerFrame());
        }
        stream.writeFrequency(this.sample.getBaseFrequency());
        stream.writeEditor(this.getEditorBounds());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    boolean edit() {
        this.sampleDialog.show();
        return true;
    }

    @Override
    boolean editAfterMake() {
        return this.edit();
    }

    String getSampleSuffix() {
        String suffix;
        switch (SynthSample.getFileType(this.file.getName())) {
            case 1: {
                suffix = "AIFF";
                break;
            }
            case 2: {
                suffix = "WAV";
                break;
            }
            default: {
                suffix = "unknown";
            }
        }
        return suffix;
    }

    @Override
    boolean loadFromFile(File file) {
        boolean result = true;
        SynthSample tempSample = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            switch (SynthSample.getFileType(file.getName())) {
                case 1: {
                    tempSample = new SynthSampleAIFF(stream);
                    break;
                }
                case 2: {
                    tempSample = new SynthSampleWAV(stream);
                    break;
                }
                default: {
                    AlertUser.showError("Unrecognized sample file suffix.");
                }
            }
            if (tempSample != null) {
                this.setModified(true);
                this.setSample(tempSample);
                result = false;
            }
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            AlertUser.showError(e);
        }
        catch (SecurityException e) {
            AlertUser.showError(e);
        }
        this.file = file;
        return result;
    }

    SynthSample getSample() {
        return this.sample;
    }

    void setF2R(double value) {
        this.f2rJack.sendMessage(Wire.clock.now(), value);
    }

    @Override
    public void queueOn(int time) {
        super.queueOn(time);
        this.update();
    }

    @Override
    public void queueLoop(int time) {
        super.queueLoop(time);
        this.update();
    }

    public void update() {
        double f2r = Synth.getFrameRate() / this.sample.getBaseFrequency();
        this.setF2R(f2r);
    }

    void setSample(SynthSample sample) {
        if (this.sample != null) {
            this.sample.delete();
        }
        this.sample = sample;
        this.channelData = sample;
        this.update();
    }

    void remakeSample(int numFrames, int numChannels) {
        this.file = null;
        this.setSample(new SynthSample(numFrames, numChannels));
    }

    @Override
    public String getTagName() {
        return "sample";
    }

    @Override
    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        super.generateSource(writer, phase);
        switch (phase) {
            case 0: {
                if (this.file == null) {
                    writer.println("SynthSample " + this.getName() + ";");
                    break;
                }
                writer.println("static SynthSample " + this.getName() + ";");
                break;
            }
            case 1: {
                if (this.file == null) {
                    writer.println(String.valueOf(this.getName()) + " = new SynthSample( synthContext, " + this.sample.getNumFrames() + ", " + this.sample.getChannelsPerFrame() + " );");
                    writer.println(String.valueOf(this.getName()) + ".setBaseFrequency( " + this.sample.getBaseFrequency() + " );");
                    break;
                }
                writer.println("if( " + this.getName() + " == null )" + "loadSample_" + this.getName() + "( synthContext );");
                break;
            }
            case 3: {
                if (this.file == null) break;
                writer.println();
                writer.println("public void loadSample_" + this.getName() + "( SynthContext synthContext )");
                writer.println("{");
                writer.indent();
                writer.println("try {");
                writer.indent();
                writer.println("InputStream stream = (InputStream) (new FileInputStream( \"" + Wire.makePathPortable(this.file.getPath()) + "\" ));");
                writer.println(String.valueOf(this.getName()) + " = new SynthSample" + this.getSampleSuffix() + "( synthContext, stream );");
                writer.println("stream.close();");
                writer.println(String.valueOf(this.getName()) + ".setBaseFrequency( " + this.sample.getBaseFrequency() + " );");
                writer.undent();
                writer.println("} catch( IOException e) {");
                writer.indent();
                writer.println("System.err.println( e );");
                writer.undent();
                writer.println("}");
                writer.undent();
                writer.println("}");
            }
        }
    }
}

