/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.wire.Module;
import com.softsynth.wire.OutputQueueJack;
import com.softsynth.wire.SaveAsStream;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;

abstract class QueuedDataModule
extends Module
implements ActionListener {
    SynthChannelData channelData;
    JButton onButton;
    JButton offButton;
    JButton loopButton;
    JButton clearButton;
    OutputQueueJack outJack;
    boolean useAutoStop = false;

    SynthChannelData getChannelData() {
        return this.channelData;
    }

    @Override
    public void calculateSize() {
        this.panel.setSize(70, 108);
    }

    public void clear(int time) {
        this.outJack.clear(time);
    }

    public void queue(int time) {
        this.outJack.queue(time, this.channelData, 0, this.channelData.getNumFrames());
    }

    public void queueLoop(int time) {
        this.outJack.queueLoop(time, this.channelData, 0, this.channelData.getNumFrames());
    }

    public void queueOn(int time) {
        this.outJack.queueOn(time, this.channelData);
    }

    public void queueOff(int time) {
        this.outJack.queueOff(time, this.channelData);
    }

    @Override
    public void noteOn(int time, double frequency, double amplitude) {
        this.clear(time);
        this.queueOn(time);
    }

    @Override
    public void noteOff(int time) {
        this.queueOff(time);
    }

    public void setAutoStop(boolean isAuto) {
        this.useAutoStop = isAuto;
    }

    public boolean getAutoStop() {
        return this.useAutoStop;
    }

    @Override
    public void setupJacks() {
        this.onButton = new JButton("On");
        this.panel.add(this.onButton);
        this.onButton.addActionListener(this);
        this.offButton = new JButton("Off");
        this.panel.add(this.offButton);
        this.offButton.addActionListener(this);
        this.loopButton = new JButton("Loop");
        this.panel.add(this.loopButton);
        this.loopButton.addActionListener(this);
        this.clearButton = new JButton("Clear");
        this.panel.add(this.clearButton);
        this.clearButton.addActionListener(this);
        this.outJack = new OutputQueueJack(this, "output");
        this.addJackCanvas(this.outJack);
    }

    @Override
    void saveContentToStream(SaveAsStream stream) throws IOException {
        super.saveContentToStream(stream);
        stream.startTag("flags");
        stream.writeAttribute("autostop", this.getAutoStop() ? 1 : 0);
        stream.endTag();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Clear")) {
            this.clear(Synth.getTickCount());
        } else if (cmd.equals("On")) {
            this.queueOn(Synth.getTickCount());
        } else if (cmd.equals("Off")) {
            this.queueOff(Synth.getTickCount());
        } else if (cmd.equals("Loop")) {
            this.queueLoop(Synth.getTickCount());
        }
    }
}

