/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.EnvelopePoints;
import com.softsynth.jsyn.view11x.EnvelopeEditor;
import com.softsynth.tools.view.TextFieldDouble;
import com.softsynth.wire.EnvelopeModule;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class EnvelopeDialog
extends Dialog {
    EnvelopeEditor editor;
    EnvelopeModule module;
    Checkbox pointsBox;
    Checkbox sustainBox;
    Checkbox releaseBox;
    Checkbox autoBox;
    Button onButton;
    Button offButton;
    Button clearButton;
    Button yUpButton;
    Button yDownButton;
    TextFieldDouble zoomField;

    public EnvelopeDialog(Frame frame, EnvelopeModule eModule, EnvelopePoints points) {
        super(frame, eModule.getName(), false);
        this.module = eModule;
        this.setSize(600, 300);
        this.setLayout(new BorderLayout());
        this.editor = new EnvelopeEditor();
        this.editor.setMaxPoints(128);
        this.editor.setBackground(Color.cyan);
        this.editor.setPoints(points);
        this.add((Component)this.editor, "Center");
        Panel buttonPanel = new Panel();
        this.add((Component)buttonPanel, "South");
        CheckboxGroup cbg = new CheckboxGroup();
        this.pointsBox = new Checkbox("P", cbg, true);
        this.pointsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnvelopeDialog.this.editor.setMode(0);
            }
        });
        buttonPanel.add(this.pointsBox);
        this.sustainBox = new Checkbox("S", cbg, false);
        this.sustainBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnvelopeDialog.this.editor.setMode(1);
            }
        });
        buttonPanel.add(this.sustainBox);
        this.releaseBox = new Checkbox("R", cbg, false);
        this.releaseBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnvelopeDialog.this.editor.setMode(2);
            }
        });
        buttonPanel.add(this.releaseBox);
        this.autoBox = new Checkbox("AutoStop", eModule.getAutoStop());
        this.autoBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnvelopeDialog.this.module.setAutoStop(EnvelopeDialog.this.autoBox.getState());
            }
        });
        buttonPanel.add(this.autoBox);
        this.onButton = new Button("On");
        buttonPanel.add(this.onButton);
        this.onButton.addActionListener(this.module);
        this.offButton = new Button("Off");
        buttonPanel.add(this.offButton);
        this.offButton.addActionListener(this.module);
        this.clearButton = new Button("Clear");
        buttonPanel.add(this.clearButton);
        this.clearButton.addActionListener(this.module);
        this.yUpButton = new Button("Y*2");
        buttonPanel.add(this.yUpButton);
        this.yUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvelopeDialog.this.scaleEnvelopeValues(2.0);
            }
        });
        this.yDownButton = new Button("Y/2");
        buttonPanel.add(this.yDownButton);
        this.yDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvelopeDialog.this.scaleEnvelopeValues(0.5);
            }
        });
        double max = this.getMaxEnvelopeValue(this.editor.getPoints());
        this.editor.setMaxWorldY(max);
        buttonPanel.add(new Label("YMax ="));
        this.zoomField = new TextFieldDouble(max, 8);
        buttonPanel.add(this.zoomField);
        this.zoomField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double val = EnvelopeDialog.this.zoomField.getValue();
                    EnvelopeDialog.this.editor.setMaxWorldY(val);
                    EnvelopeDialog.this.editor.repaint();
                }
                catch (NumberFormatException exp) {
                    EnvelopeDialog.this.zoomField.setText("ERROR");
                    EnvelopeDialog.this.zoomField.selectAll();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().hide();
            }
        });
        this.validate();
    }

    double getMaxEnvelopeValue(EnvelopePoints points) {
        double max = 1.0;
        int i = 0;
        while (i < points.size()) {
            double[] dar = points.getPoint(i);
            if (dar[1] > max) {
                max = dar[1];
            }
            ++i;
        }
        return max;
    }

    void scaleEnvelopeValues(double scalar) {
        EnvelopePoints points = this.editor.getPoints();
        int i = 0;
        while (i < points.size()) {
            double[] dar = points.getPoint(i);
            dar[1] = dar[1] * scalar;
            ++i;
        }
        this.editor.repaint();
        this.editor.updateEditListeners();
    }

    public void update(Object o, Object arg) {
        this.autoBox.setState(this.module.getAutoStop());
    }

    @Override
    public void show() {
        this.update(this.module, null);
        super.show();
    }
}

