/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

class BarGraphDisplay
extends Canvas {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    double value;
    double min = 0.0;
    double max = 1.0;
    int orientation = 1;
    double scalar = 1.0;
    Graphics grCon = null;

    public BarGraphDisplay(int orientation, double value, double min, double max) {
        this.orientation = orientation;
        this.value = value;
        this.min = min;
        this.max = max;
        this.updateScalar();
        this.setBackground(Color.darkGray);
        this.setForeground(Color.orange);
    }

    void updateScalar() {
        this.scalar = 1.0 / (this.max - this.min);
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
        this.updateScalar();
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.updateScalar();
    }

    public void set(double newValue) {
        double oldValue = this.value;
        this.value = newValue;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.grCon = g;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(this.getForeground());
        int y = (int)((double)height * (this.value - this.min) * this.scalar);
        g.fillRect(0, height - y, width, y);
    }
}

