/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.support;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.TextArea;

public class PropertyViewApplet
extends Applet {
    TextArea textArea;

    public static void main(String[] args) {
        PropertyViewApplet applet = new PropertyViewApplet();
        Frame f = new Frame("Applet Frame");
        f.add("Center", applet);
        applet.init();
        applet.start();
        f.setSize(600, 400);
        f.show();
    }

    @Override
    public void start() {
        System.out.println("Starting PropertyViewApplet");
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea(10, 80);
        this.add("Center", this.textArea);
        this.write("System Properties\n");
        this.showProperties();
        this.write("Free  Memory = " + Runtime.getRuntime().freeMemory() + "\n");
        this.write("Total Memory = " + Runtime.getRuntime().totalMemory() + "\n");
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void write(String msg) {
        if (this.textArea != null) {
            this.textArea.append(msg);
        } else {
            System.out.print(msg);
        }
    }

    void showProperties() {
        this.showProp("java.version");
        this.showProp("java.vendor");
        this.showProp("java.home");
        this.showProp("java.library.path");
        this.showProp("java.vm.specification.version");
        this.showProp("java.vm.specification.vendor");
        this.showProp("java.vm.specification.name");
        this.showProp("java.vm.version");
        this.showProp("java.vm.vendor");
        this.showProp("java.vm.name");
        this.showProp("java.specification.version");
        this.showProp("java.specification.vendor");
        this.showProp("java.specification.name");
        this.showProp("java.class.version");
        this.showProp("java.class.path");
        this.showProp("java.ext.dirs");
        this.showProp("os.name");
        this.showProp("os.arch");
        this.showProp("os.version");
    }

    void showProp(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null) {
                value = "UNDEFINED";
            }
            this.write(String.valueOf(key) + " = " + value + "\n");
        }
        catch (SecurityException e) {
            this.write(e + " accessing " + key + "\n");
        }
    }

    @Override
    public void stop() {
        this.removeAll();
    }
}

