/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.midifile;

import com.softsynth.util.NumericOutput;

public class MIDIStandard {
    public static final int MThd_ID = 1297377380;
    public static final int MTrk_ID = 1297379947;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLYPHONIC_AFTERTOUCH = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_AFTERTOUCH = 208;
    public static final int PITCH_BEND = 224;
    public static final int SYSTEM_COMMON = 240;
    public static final int META_EVENT = 255;
    public static final int META_SEQUENCE_NUMBER = 0;
    public static final int META_TEXT_EVENT = 1;
    public static final int META_COPYRIGHT = 2;
    public static final int META_SEQUENCE_NAME = 3;
    public static final int META_INSTRUMENT_NAME = 4;
    public static final int META_LYRIC = 5;
    public static final int META_MARKER = 6;
    public static final int META_CUE_POINT = 7;
    public static final int META_CHANNEL_PREFIX = 32;
    public static final int META_END_OF_TRACK = 47;
    public static final int META_SET_TEMPO = 81;
    public static final int META_SMPTE_OFFSET = 84;
    public static final int META_TIME_SIGNATURE = 88;
    public static final int META_KEY_SIGNATURE = 89;
    public static final String[] pitchNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    static final int[] channelByteLengths = new int[]{3, 3, 3, 3, 2, 2, 3, 1};
    static final int[] systemByteLengths = new int[]{2, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

    public static int bytesPerMessage(int command) {
        if (command < 128) {
            return 0;
        }
        if (command >= 240) {
            return systemByteLengths[command & 0xF];
        }
        return channelByteLengths[(command >> 4) - 8];
    }

    static String textMetaEventToString(int type, byte[] b) {
        String s = "MetaEvent";
        switch (type) {
            case 1: {
                s = String.valueOf(s) + "Text";
                break;
            }
            case 2: {
                s = String.valueOf(s) + "Copyright";
                break;
            }
            case 3: {
                s = String.valueOf(s) + "SequenceName";
                break;
            }
            case 4: {
                s = String.valueOf(s) + "Instrument";
                break;
            }
            case 5: {
                s = String.valueOf(s) + "Lyric";
                break;
            }
            case 6: {
                s = String.valueOf(s) + "Marker";
                break;
            }
            case 7: {
                s = String.valueOf(s) + "CuePoint";
                break;
            }
            default: {
                s = String.valueOf(s) + "unrecognized";
            }
        }
        String typeString = "0x" + NumericOutput.integerToString(type, 2, true, 16);
        s = String.valueOf(s) + "( " + typeString + ", ";
        s = String.valueOf(s) + (b == null ? "NULL" : new String(b));
        s = String.valueOf(s) + " )";
        return s;
    }

    static String bytesToString(byte[] b) {
        String s = null;
        if (b == null) {
            s = ", 0";
        } else {
            s = ", " + b.length;
            int i = 0;
            while (i < b.length) {
                s = String.valueOf(s) + ", 0x" + NumericOutput.integerToString(b[i] & 0xFF, 2, true, 16);
                ++i;
            }
        }
        return s;
    }

    public static String pitchToString(int pitch) {
        int octave = pitch / 12 - 1;
        int note = pitch % 12;
        return String.valueOf(pitchNames[note]) + octave;
    }

    public static String metaEventToString(int type, byte[] b) {
        String s;
        if (type >= 1 && type <= 7) {
            s = MIDIStandard.textMetaEventToString(type, b);
        } else {
            s = "Meta_";
            switch (type) {
                case 32: {
                    s = String.valueOf(s) + "ChannelPrefix";
                    break;
                }
                case 47: {
                    s = String.valueOf(s) + "EndOfTrack";
                    break;
                }
                case 81: {
                    s = String.valueOf(s) + "SetTempo";
                    break;
                }
                case 84: {
                    s = String.valueOf(s) + "SMPTE_Offset";
                    break;
                }
                case 88: {
                    s = String.valueOf(s) + "TimeSignature";
                    break;
                }
                case 89: {
                    s = String.valueOf(s) + "KeySignature";
                    break;
                }
                default: {
                    s = String.valueOf(s) + "unrecognized";
                }
            }
            String typeString = "0x" + NumericOutput.integerToString(type, 2, true, 16);
            s = String.valueOf(s) + "( " + typeString + MIDIStandard.bytesToString(b) + " )";
        }
        return s;
    }

    public static String messageToString(int command, int data1, int data2) {
        String s;
        int type = command & 0xF0;
        int channel = (command & 0xF) + 1;
        String s1 = "0x" + NumericOutput.integerToString(data1, 2, true, 16);
        String s2 = "0x" + NumericOutput.integerToString(data2, 2, true, 16);
        switch (type) {
            case 128: {
                s = "NoteOff( " + channel + ", " + MIDIStandard.pitchToString(data1) + "=" + s1 + ", " + s2 + " )";
                break;
            }
            case 144: {
                s = "NoteOn( " + channel + ", " + MIDIStandard.pitchToString(data1) + "=" + s1 + ", " + s2 + " )";
                break;
            }
            case 160: {
                s = "PolyTouch( " + channel + ", " + s1 + ", " + s2 + " )";
                break;
            }
            case 176: {
                s = "Control( " + channel + ", " + s1 + ", " + s2 + " )";
                break;
            }
            case 192: {
                s = "Program( " + channel + ", " + s1 + " )";
                break;
            }
            case 208: {
                s = "ChannelTouch( " + channel + ", " + s1 + " )";
                break;
            }
            case 224: {
                s = "PitchBend( " + channel + ", 0x" + Integer.toHexString((data2 << 7) + data1) + " )";
                break;
            }
            default: {
                s = "System";
            }
        }
        return s;
    }
}

