/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.midifile;

import com.softsynth.midifile.MIDIFileOutput;
import com.softsynth.midifile.MIDIStandard;
import com.softsynth.util.NumericOutput;
import java.io.IOException;

public class MIDIFileEvent
implements Cloneable {
    int ticks;
    double seconds;
    public int command;
    public int data1;
    public int data2;

    public MIDIFileEvent(int ticks, int command, int data1, int data2) {
        this.ticks = ticks;
        this.command = command;
        this.data1 = data1;
        this.data2 = data2;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setSeconds(double seconds) {
        this.seconds = seconds;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getCommand() {
        return this.command;
    }

    public int getChannel() {
        return (this.command & 0xF) + 1;
    }

    public void setChannel(int channel) {
        int binChannel = channel - 1;
        this.command = (this.command & 0xF0) + binChannel;
    }

    public void write(MIDIFileOutput mfout) throws IOException {
        mfout.writeEvent(this.ticks, this.command, this.data1, this.data2);
    }

    String getTimeString() {
        return String.valueOf(NumericOutput.integerToString(this.ticks, 5)) + ", " + NumericOutput.doubleToString(this.seconds, 8, 4);
    }

    public String toString() {
        return String.valueOf(this.getTimeString()) + ", " + MIDIStandard.messageToString(this.command, this.data1, this.data2);
    }

    public synchronized Object clone() {
        try {
            MIDIFileEvent event = (MIDIFileEvent)super.clone();
            return event;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }
}

