/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

import com.softsynth.math.JustRatio;
import java.util.ArrayList;

public class PrimeFactors {
    private static final int SIEVE_SIZE = 1000;
    private static int[] primes;
    private final int[] factors;

    static {
        boolean[] sieve = new boolean[1000];
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        int i = 2;
        while (i < 500) {
            if (!sieve[i]) {
                primeList.add(i);
                int multiple = 2 * i;
                while (multiple < 1000) {
                    sieve[multiple] = true;
                    multiple += i;
                }
            }
            ++i;
        }
        primes = PrimeFactors.primeListToArray(primeList);
    }

    private static int[] primeListToArray(ArrayList<Integer> primeList) {
        int[] primes = new int[primeList.size()];
        int i = 0;
        while (i < primes.length) {
            primes[i] = primeList.get(i);
            ++i;
        }
        return primes;
    }

    public PrimeFactors(int[] factors) {
        this.factors = factors;
    }

    public PrimeFactors(int numerator, int denominator) {
        int[] topFactors = PrimeFactors.factor(numerator);
        int[] bottomFactors = PrimeFactors.factor(denominator);
        this.factors = PrimeFactors.subtract(topFactors, bottomFactors);
    }

    public PrimeFactors subtract(PrimeFactors pf) {
        return new PrimeFactors(PrimeFactors.subtract(this.factors, pf.factors));
    }

    public PrimeFactors add(PrimeFactors pf) {
        return new PrimeFactors(PrimeFactors.add(this.factors, pf.factors));
    }

    /*
     * Unable to fully structure code
     */
    public static int[] subtract(int[] factorsA, int[] factorsB) {
        block5: {
            if (factorsA.length > factorsB.length) {
                max = factorsA.length;
                min = factorsB.length;
            } else {
                min = factorsA.length;
                max = factorsB.length;
            }
            primeList = new ArrayList<Integer>();
            i = 0;
            while (i < min) {
                primeList.add(factorsA[i] - factorsB[i]);
                ++i;
            }
            if (factorsA.length <= factorsB.length) ** GOTO lbl24
            while (i < max) {
                primeList.add(factorsA[i]);
                ++i;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                primeList.add(0 - factorsB[i]);
                ++i;
lbl24:
                // 2 sources

                ** while (i < max)
            }
        }
        PrimeFactors.trimPrimeList(primeList);
        return PrimeFactors.primeListToArray(primeList);
    }

    public static int[] add(int[] factorsA, int[] factorsB) {
        int min;
        int max;
        if (factorsA.length > factorsB.length) {
            max = factorsA.length;
            min = factorsB.length;
        } else {
            min = factorsA.length;
            max = factorsB.length;
        }
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        int i = 0;
        while (i < min) {
            primeList.add(factorsA[i] + factorsB[i]);
            ++i;
        }
        if (factorsA.length > factorsB.length) {
            while (i < max) {
                primeList.add(factorsA[i]);
                ++i;
            }
        } else if (factorsB.length > factorsA.length) {
            while (i < max) {
                primeList.add(factorsB[i]);
                ++i;
            }
        }
        PrimeFactors.trimPrimeList(primeList);
        return PrimeFactors.primeListToArray(primeList);
    }

    private static void trimPrimeList(ArrayList<Integer> primeList) {
        int i = primeList.size() - 1;
        while (i >= 0) {
            if (primeList.get(i) != 0) break;
            primeList.remove(i);
            --i;
        }
    }

    public static int[] factor(int n) {
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        int i = 0;
        int p = primes[i];
        int exponent = 0;
        while (n > 1) {
            int d = n / p;
            int m = d * p;
            if (m == n) {
                n = d;
                ++exponent;
                continue;
            }
            primeList.add(exponent);
            exponent = 0;
            p = primes[++i];
        }
        if (exponent > 0) {
            primeList.add(exponent);
        }
        return PrimeFactors.primeListToArray(primeList);
    }

    public static int getPrime(int i) {
        return primes[i];
    }

    public static int getPrimeCount() {
        return primes.length;
    }

    public JustRatio getJustRatio() {
        long n = 1L;
        long d = 1L;
        int i = 0;
        while (i < this.factors.length) {
            int k;
            int exponent = this.factors[i];
            int p = primes[i];
            if (exponent > 0) {
                k = 0;
                while (k < exponent) {
                    n *= (long)p;
                    ++k;
                }
            } else if (exponent < 0) {
                exponent = 0 - exponent;
                k = 0;
                while (k < exponent) {
                    d *= (long)p;
                    ++k;
                }
            }
            ++i;
        }
        return new JustRatio(n, d);
    }

    public int[] getFactors() {
        return (int[])this.factors.clone();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.printFactors(buffer, 1);
        buffer.append("/");
        this.printFactors(buffer, -1);
        return buffer.toString();
    }

    private void printFactors(StringBuffer buffer, int sign) {
        boolean gotSome = false;
        int i = 0;
        while (i < this.factors.length) {
            int pf = this.factors[i] * sign;
            if (pf > 0) {
                if (gotSome) {
                    buffer.append('*');
                }
                int prime = primes[i];
                if (pf == 1) {
                    buffer.append("" + prime);
                } else if (pf == 2) {
                    buffer.append(String.valueOf(prime) + "*" + prime);
                } else if (pf > 2) {
                    buffer.append("(" + prime + "^" + pf + ")");
                }
                gotSome = true;
            }
            ++i;
        }
        if (!gotSome) {
            buffer.append("1");
        }
    }
}

