/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view11x;

import com.softsynth.jsyn.EnvelopePoints;
import com.softsynth.jsyn.view11x.EditListener;
import com.softsynth.jsyn.view11x.XYController;
import com.softsynth.util.NumericOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class EnvelopeEditor
extends XYController
implements MouseListener,
MouseMotionListener {
    EnvelopePoints points;
    Vector listeners;
    int dragIndex = -1;
    double dragLowLimit;
    double dragHighLimit;
    double[] draggedPoint;
    double xBefore;
    double xPicked;
    double dragWX;
    double dragWY;
    int maxPoints = Integer.MAX_VALUE;
    int radius = 3;
    double verticalBarSpacing = 1.0;
    boolean verticalBarsEnabled = false;
    double maximumXRange = Double.MAX_VALUE;
    double minimumXRange = 0.1;
    int rangeStart = -1;
    int rangeEnd = -1;
    int mode = 0;
    public static final int EDIT_POINTS = 0;
    public static final int SELECT_SUSTAIN = 1;
    public static final int SELECT_RELEASE = 2;
    Color rangeColor = Color.red;
    Color sustainColor = Color.blue;
    Color releaseColor = Color.yellow;
    Color overlapColor = Color.green;
    Color firstLineColor = Color.gray;

    public EnvelopeEditor() {
        this.listeners = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setMaximumXRange(double maxXRange) {
        this.maximumXRange = maxXRange;
    }

    public double getMaximumXRange() {
        return this.maximumXRange;
    }

    public void setMinimumXRange(double minXRange) {
        this.minimumXRange = minXRange;
    }

    public double getMinimumXRange() {
        return this.minimumXRange;
    }

    public void setSelection(int start, int end) {
        switch (this.mode) {
            case 1: {
                this.points.setSustainLoop(start, end);
                break;
            }
            case 2: {
                this.points.setReleaseLoop(start, end);
            }
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void addEditListener(EditListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeEditListener(EditListener listener) {
        this.listeners.removeElement(listener);
    }

    public void updateEditListeners() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            EditListener listener = (EditListener)e.nextElement();
            listener.objectEdited(this, this.points);
        }
    }

    public void setMaxPoints(int maxPoints) {
        this.maxPoints = maxPoints;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public void setPoints(EnvelopePoints points) {
        this.points = points;
        this.setMaxWorldY(points.getMaximumValue());
    }

    public EnvelopePoints getPoints() {
        return this.points;
    }

    public int findPointBefore(double wx) {
        int pnt = -1;
        double px = 0.0;
        this.xBefore = 0.0;
        int i = 0;
        while (i < this.points.size()) {
            if ((px += this.points.getPoint(i)[0]) > wx) break;
            pnt = i++;
            this.xBefore = px;
        }
        return pnt;
    }

    int pickPoint(double wx, double wxAperture, double wy, double wyAperture) {
        double px = 0.0;
        double wxLow = wx - wxAperture;
        double wxHigh = wx + wxAperture;
        double wyLow = wy - wyAperture;
        double wyHigh = wy + wyAperture;
        double wxScale = 1.0 / wxAperture;
        double wyScale = 1.0 / wyAperture;
        int bestPoint = -1;
        double bestDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < this.points.size()) {
            double ndy;
            double ndx;
            double dist;
            double[] dar = this.points.getPoint(i);
            px += dar[0];
            double py = dar[1];
            if (px > wxLow && px < wxHigh && py > wyLow && py < wyHigh && (dist = (ndx = (px - wx) * wxScale) * ndx + (ndy = (py - wy) * wyScale) * ndy) < bestDistance) {
                bestPoint = i;
                bestDistance = dist;
                this.xPicked = px;
            }
            ++i;
        }
        return bestPoint;
    }

    void clickDownRange(boolean shiftDown, int gx, int gy) {
        this.setSelection(-1, -1);
        this.rangeStart = this.rangeEnd = gx;
        this.repaint();
    }

    void dragRange(int gx, int gy) {
        this.rangeEnd = gx;
        this.repaint();
    }

    void clickUpRange(int gx, int gy) {
        this.dragRange(gx, gy);
        if (this.rangeEnd < this.rangeStart) {
            int temp = this.rangeEnd;
            this.rangeEnd = this.rangeStart;
            this.rangeStart = temp;
        }
        double wx = this.convertGXtoWX(this.rangeStart);
        int i0 = this.findPointBefore(wx);
        wx = this.convertGXtoWX(this.rangeEnd);
        int i1 = this.findPointBefore(wx);
        if (i1 == i0) {
            if (gx < 0) {
                this.setSelection(0, 0);
            }
        } else if (i1 == i0 + 1) {
            this.setSelection(i1 + 1, i1 + 1);
        } else if (i1 > i0 + 1) {
            this.setSelection(i0 + 1, i1 + 1);
        }
        this.rangeStart = -1;
        this.rangeEnd = -1;
        this.updateEditListeners();
    }

    void clickDownPoints(boolean shiftDown, int gx, int gy) {
        this.dragIndex = -1;
        double wx = this.convertGXtoWX(gx);
        double wy = this.convertGYtoWY(gy);
        double wxAp = this.convertGXtoWX(this.radius + 2) - this.convertGXtoWX(0);
        double wyAp = this.convertGYtoWY(0) - this.convertGYtoWY(this.radius + 2);
        int pnt = this.pickPoint(wx, wxAp, wy, wyAp);
        if (shiftDown) {
            if (pnt >= 0) {
                this.points.removePoint(pnt);
                this.repaint();
            }
        } else if (pnt < 0) {
            if (this.points.size() < this.maxPoints) {
                pnt = this.findPointBefore(wx);
                this.dragIndex = pnt + 1;
                if (pnt == this.points.size() - 1) {
                    this.points.add(wx - this.xBefore, wy);
                } else {
                    this.points.insert(this.dragIndex, wx - this.xBefore, wy);
                }
                this.dragLowLimit = this.xBefore;
                this.dragHighLimit = wx + (this.maximumXRange - this.points.getTotalDuration());
                this.repaint();
            }
        } else {
            this.dragIndex = pnt;
            this.dragLowLimit = this.dragIndex <= 0 ? 0.0 : this.xPicked - this.points.getPoint(this.dragIndex)[0];
            this.dragHighLimit = this.xPicked + (this.maximumXRange - this.points.getTotalDuration());
        }
        if (this.dragIndex >= 0) {
            this.draggedPoint = this.points.getPoint(this.dragIndex);
        }
    }

    void dragPoint(int gx, int gy) {
        if (this.dragIndex < 0) {
            return;
        }
        double wx = this.convertGXtoWX(gx);
        if (wx < this.dragLowLimit) {
            wx = this.dragLowLimit;
        } else if (wx > this.dragHighLimit) {
            wx = this.dragHighLimit;
        }
        this.draggedPoint[0] = wx - this.dragLowLimit;
        double wy = this.convertGYtoWY(gy);
        this.draggedPoint[1] = wy = this.clipWorldY(wy);
        this.dragWY = wy;
        this.dragWX = wx;
        this.repaint();
    }

    void clickUpPoints(int gx, int gy) {
        this.dragPoint(gx, gy);
        this.updateEditListeners();
        this.dragIndex = -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.points == null) {
            return;
        }
        if (this.mode == 0) {
            this.dragPoint(x, y);
        } else {
            this.dragRange(x, y);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.points == null) {
            return;
        }
        if (this.mode == 0) {
            this.clickDownPoints(e.isShiftDown(), x, y);
        } else {
            this.clickDownRange(e.isShiftDown(), x, y);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.points == null) {
            return;
        }
        if (this.mode == 0) {
            this.clickUpPoints(x, y);
        } else {
            this.clickUpRange(x, y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void drawRange(Graphics g) {
        if (this.rangeStart >= 0) {
            int height = this.bounds().height;
            int gx0 = 0;
            int gx1 = 0;
            if (this.rangeEnd < this.rangeStart) {
                gx0 = this.rangeEnd;
                gx1 = this.rangeStart;
            } else {
                gx0 = this.rangeStart;
                gx1 = this.rangeEnd;
            }
            g.setColor(this.rangeColor);
            g.fillRect(gx0, 0, gx1 - gx0, height);
        }
    }

    void drawUnderSelection(Graphics g, int start, int end) {
        if (start >= 0) {
            int height = this.bounds().height;
            int gx0 = 0;
            int gx1 = this.radius;
            double wx = 0.0;
            int i = 0;
            while (i <= end - 1) {
                double[] dar = (double[])this.points.elementAt(i);
                wx += dar[0];
                if (start == i + 1) {
                    gx0 = this.convertWXtoGX(wx) + this.radius;
                }
                if (end == i + 1) {
                    gx1 = this.convertWXtoGX(wx) + this.radius;
                }
                ++i;
            }
            if (gx0 == gx1) {
                gx0 -= this.radius;
            }
            g.fillRect(gx0, 0, gx1 - gx0, height);
        }
    }

    public void drawSelections(Graphics g) {
        int sus0 = this.points.getSustainBegin();
        int sus1 = this.points.getSustainEnd();
        int rel0 = this.points.getReleaseBegin();
        int rel1 = this.points.getReleaseEnd();
        g.setColor(this.sustainColor);
        this.drawUnderSelection(g, sus0, sus1);
        g.setColor(this.releaseColor);
        this.drawUnderSelection(g, rel0, rel1);
        if (sus1 >= rel0) {
            int sel1 = rel1 < sus1 ? rel1 : sus1;
            g.setColor(this.overlapColor);
            this.drawUnderSelection(g, rel0, sel1);
        }
    }

    public void drawUnderlay(Graphics g) {
        if (this.dragIndex < 0) {
            this.drawSelections(g);
            this.drawRange(g);
        }
        if (this.verticalBarsEnabled) {
            this.drawVerticalBars(g);
        }
    }

    public void setVerticalBarsEnabled(boolean flag) {
        this.verticalBarsEnabled = flag;
    }

    public boolean getVerticalBarsEnabled() {
        return this.verticalBarsEnabled;
    }

    public void setVerticalBarSpacing(double spacing) {
        this.verticalBarSpacing = spacing;
    }

    public double getVerticalBarSpacing() {
        return this.verticalBarSpacing;
    }

    void drawVerticalBars(Graphics g) {
        int gx;
        int width = this.bounds().width;
        int height = this.bounds().height;
        double wx = this.verticalBarSpacing;
        g.setColor(Color.lightGray);
        while ((gx = this.convertWXtoGX(wx)) <= width) {
            g.drawLine(gx, 0, gx, height);
            wx += this.verticalBarSpacing;
        }
    }

    public void drawPoints(Graphics g, Color lineColor) {
        double wx = 0.0;
        int gx1 = 0;
        int gy1 = this.bounds().height;
        int i = 0;
        while (i < this.points.size()) {
            double[] dar = (double[])this.points.elementAt(i);
            double wy = dar[1];
            int gx2 = this.convertWXtoGX(wx += dar[0]);
            int gy2 = this.convertWYtoGY(wy);
            if (i == 0) {
                g.setColor(this.isEnabled() ? this.firstLineColor : this.firstLineColor.darker());
                g.drawLine(gx1, gy1, gx2, gy2);
                g.setColor(this.isEnabled() ? lineColor : lineColor.darker());
            } else if (i > 0) {
                g.drawLine(gx1, gy1, gx2, gy2);
            }
            int diameter = 2 * this.radius + 1;
            g.fillOval(gx2 - this.radius, gy2 - this.radius, diameter, diameter);
            gx1 = gx2;
            gy1 = gy2;
            ++i;
        }
    }

    public void drawAllPoints(Graphics g) {
        this.drawPoints(g, this.getForeground());
    }

    @Override
    public void paint(Graphics g) {
        double wx = 0.0;
        int width = this.bounds().width;
        int height = this.bounds().height;
        g.setColor(this.isEnabled() ? this.getBackground() : this.getBackground().darker());
        g.fillRect(0, 0, width, height);
        if (this.points == null) {
            g.setColor(this.getForeground());
            g.drawString("No EnvelopePoints", 10, 30);
            return;
        }
        if (this.points.size() > 0) {
            double radiusWX;
            wx = this.points.getTotalDuration();
            double wxFar = wx + (radiusWX = this.convertGXtoWX(this.radius) - this.getMinWorldX());
            if (wxFar > this.getMaxWorldX()) {
                if (wx > this.maximumXRange) {
                    wxFar = this.maximumXRange;
                }
                this.setMaxWorldX(wxFar);
            } else if (wx < this.getMaxWorldX() * 0.7) {
                double newMax = wx / 0.7001;
                if (newMax < this.minimumXRange) {
                    newMax = this.minimumXRange;
                }
                this.setMaxWorldX(newMax);
            }
        }
        this.drawUnderlay(g);
        this.drawAllPoints(g);
        g.drawString(String.valueOf(this.points.getName()) + ", len=" + NumericOutput.doubleToString(wx, 7, 3), 5, 15);
        if (this.draggedPoint != null) {
            String s = "i=" + this.dragIndex + ", dur=" + NumericOutput.doubleToString(this.draggedPoint[0], 7, 3) + ", y = " + NumericOutput.doubleToString(this.draggedPoint[1], 8, 4);
            g.drawString(s, 5, 30);
        }
    }
}

