/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.util.HarmonicTable;
import com.softsynth.jsyn.view102.HarmonicFader;
import com.softsynth.jsyn.view102.WaveDisplay;
import java.awt.Button;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;

public class WaveMaker
extends Panel {
    HarmonicTable table;
    HarmonicFader[] faders;
    int numSamples;
    int numPartials;
    public short[] data;
    Button sawButton;
    Button squareButton;
    Button triButton;
    Button clearButton;
    double minVal = 0.0;
    double maxVal = 0.0;
    WaveDisplay display;

    public WaveMaker(HarmonicTable table, WaveDisplay display) {
        this.table = table;
        this.display = display;
        this.numSamples = table.length();
        this.numPartials = table.getNumPartials();
        this.data = new short[this.numSamples];
        this.faders = new HarmonicFader[this.numPartials];
        this.setLayout(new GridLayout(1, 0));
        int i = 0;
        while (i < this.numPartials) {
            this.faders[i] = new HarmonicFader(this, i);
            this.add(this.faders[i]);
            ++i;
        }
        this.sawButton = new Button("Saw");
        this.add(this.sawButton);
        this.squareButton = new Button("Sqr");
        this.add(this.squareButton);
        this.triButton = new Button("Tri");
        this.add(this.triButton);
        this.clearButton = new Button("Clr");
        this.add(this.clearButton);
        table.clear();
        this.updateFaders();
    }

    void setPartial(int index, double value) {
        this.table.setPartial(index, value);
        this.table.build();
        this.display.repaint();
    }

    void updateFaders() {
        int h = 0;
        while (h < this.numPartials) {
            this.faders[h].setValue(this.table.getPartial(h));
            ++h;
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.sawButton) {
            this.table.sawtooth();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (evt.target == this.squareButton) {
            this.table.square();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (evt.target == this.triButton) {
            this.table.triangle();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (evt.target == this.clearButton) {
            this.table.clear();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        return false;
    }
}

