/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.view102.CustomFaderListener;
import com.softsynth.jsyn.view102.InternalCustomFader;
import com.softsynth.jsyn.view102.Tweakable;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public abstract class InternalLabelledFader
extends Panel
implements CustomFaderListener,
Tweakable {
    Tweakable target;
    int targetIndex;
    String faderName;
    Label nameLabel;
    Label valueLabel;
    double min;
    double max;
    protected static final int RANGE = 2000;
    protected InternalCustomFader fader;

    public InternalLabelledFader(Tweakable target, int targetIndex, String faderName, double startValue, double min, double max) {
        this.target = target == null ? this : target;
        this.targetIndex = targetIndex;
        this.faderName = faderName;
        this.min = min;
        this.max = max;
        this.setLayout(new GridLayout(0, 3));
        this.nameLabel = new Label(String.valueOf(faderName) + " ", 2);
        this.add(this.nameLabel);
        this.makeFader(this.doubleToFader(startValue));
        this.fader.addCustomFaderListener(this);
        this.fader.setUnitIncrement(20);
        this.add(this.fader);
        this.valueLabel = new Label();
        this.showValue(startValue);
        this.add(this.valueLabel);
    }

    double faderToDouble(int val) {
        return (double)val * (this.max - this.min) / 2000.0 + this.min;
    }

    int doubleToFader(double fval) {
        return (int)((fval - this.min) * 2000.0 / (this.max - this.min));
    }

    void showValue(double fval) {
        String fvalString = Double.toString(fval);
        int maxchars = fvalString.indexOf(46) + 5;
        String actualString = fvalString.length() > maxchars ? fvalString.substring(0, maxchars) : fvalString;
        this.valueLabel.setText(actualString);
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMinimum(double min) {
        this.min = min;
    }

    public void setMaximum(double max) {
        this.max = max;
    }

    public void setValue(double fval) {
        int ival = this.doubleToFader(fval);
        this.fader.setValue(ival);
    }

    @Override
    public void tweak(int idx, double fval) {
    }

    @Override
    public void customFaderValueChanged(Object jsb, int value) {
        double fval = this.faderToDouble(value);
        this.target.tweak(this.targetIndex, fval);
        this.showValue(fval);
    }

    protected abstract void makeFader(int var1);
}

