/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.view.SynthProbe;
import com.softsynth.jsyn.view.SynthProbeCircuit;
import com.softsynth.jsyn.view.SynthScopeProbePanel;
import com.softsynth.jsyn.view.UsageDisplay;
import com.softsynth.jsyn.view.WaveDisplay;
import com.softsynth.jsyn.view.WaveTrace;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Panel;

public class SynthScope
extends Panel
implements Runnable {
    SynthProbeCircuit probeCircuit;
    WaveDisplay waveDisplay;
    Button captureButton;
    Checkbox autoBox;
    Button zoomInButton;
    Button zoomOutButton;
    Button panLeftButton;
    Button panRightButton;
    Panel probeGroup;
    Panel controlPanel;
    Thread autoThread;
    boolean runAuto = false;
    int sampleSize;
    boolean autoEnable;

    public SynthScope(int sampleSize) throws SynthException {
        this.sampleSize = sampleSize;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraint = new GridBagConstraints();
        this.setLayout(gridbag);
        constraint.gridwidth = 0;
        constraint.fill = 1;
        constraint.weightx = 1.0;
        this.waveDisplay = new WaveDisplay();
        this.add(this.waveDisplay);
        this.waveDisplay.setBackground(Color.black);
        constraint.gridheight = -1;
        constraint.weighty = 1.0;
        gridbag.setConstraints(this.waveDisplay, constraint);
        constraint.weighty = 0.0;
        this.probeGroup = new Panel();
        this.add(this.probeGroup);
        constraint.gridheight = 0;
        gridbag.setConstraints(this.probeGroup, constraint);
        this.probeGroup.setLayout(new GridLayout(0, 1));
        this.controlPanel = new Panel();
        this.probeGroup.add(this.controlPanel);
        this.captureButton = new Button("Capture");
        this.controlPanel.add(this.captureButton);
        this.autoBox = new Checkbox("Auto");
        this.controlPanel.add(this.autoBox);
        this.autoBox.setState(true);
        this.zoomInButton = new Button("Zoom In");
        this.controlPanel.add(this.zoomInButton);
        this.zoomOutButton = new Button("Zoom Out");
        this.controlPanel.add(this.zoomOutButton);
        this.panLeftButton = new Button("<<<");
        this.controlPanel.add(this.panLeftButton);
        this.panRightButton = new Button(">>>");
        this.controlPanel.add(this.panRightButton);
        this.controlPanel.add(new UsageDisplay());
        this.probeCircuit = new SynthProbeCircuit(sampleSize);
        this.handleAutoBox();
    }

    public SynthScope() throws SynthException {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int period = (int)Synth.getTickRate();
        try {
            while (true) {
                Synth.sleepForTicks(period);
                SynthScope synthScope = this;
                synchronized (synthScope) {
                    while (!this.autoEnable) {
                        this.wait();
                    }
                }
                this.capture();
            }
        }
        catch (InterruptedException e) {
            return;
        }
        catch (SynthException e) {
            return;
        }
    }

    public void addProbe(SynthScopeProbePanel probePanel) throws SynthException {
        probePanel.useDisplay(this.waveDisplay);
        this.probeGroup.add(probePanel);
        this.repaint();
    }

    public void removeProbe(SynthScopeProbePanel probePanel) throws SynthException {
        probePanel.useDisplay(null);
        this.probeGroup.remove(probePanel);
        this.repaint();
    }

    public SynthScopeProbePanel createProbe(SynthOutput outPort, String name, Color color) throws SynthException {
        SynthProbe probe = this.probeCircuit.addProbe(outPort, 0);
        WaveTrace trace = new WaveTrace(probe.data, color, 1.0);
        SynthScopeProbePanel probePanel = new SynthScopeProbePanel(trace, name);
        this.addProbe(probePanel);
        return probePanel;
    }

    public synchronized void capture() throws SynthException {
        this.probeCircuit.trigger();
        Synth.sleepForTicks(this.sampleSize / Synth.getFramesPerTick() + 1);
        this.probeCircuit.readData();
        this.waveDisplay.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAutoBox() {
        if (this.autoBox.getState()) {
            if (this.autoThread == null) {
                this.autoThread = new Thread(this);
                this.autoThread.start();
            }
            SynthScope synthScope = this;
            synchronized (synthScope) {
                this.autoEnable = true;
                this.notify();
            }
        } else {
            this.autoEnable = false;
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                if (evt.target != this.captureButton) break block8;
                                this.capture();
                                return true;
                            }
                            catch (SynthException e) {
                                SynthAlert.showError((Component)this, e);
                                return true;
                            }
                        }
                        if (evt.target != this.autoBox) break block9;
                        this.handleAutoBox();
                        return true;
                    }
                    if (evt.target != this.zoomInButton) break block10;
                    this.waveDisplay.zoomIn();
                    this.waveDisplay.repaint();
                    return true;
                }
                if (evt.target != this.zoomOutButton) break block11;
                this.waveDisplay.zoomOut();
                this.waveDisplay.repaint();
                return true;
            }
            if (evt.target != this.panLeftButton) break block12;
            this.waveDisplay.panLeft();
            this.waveDisplay.repaint();
            return true;
        }
        if (evt.target == this.panRightButton) {
            this.waveDisplay.panRight();
            this.waveDisplay.repaint();
            return true;
        }
        return false;
    }
}

