/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.util.RandomOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WAVFileWriter
extends RandomOutputStream {
    static final short WAVE_FORMAT_PCM = 1;
    long riffSizePosition = 0L;
    long dataSizePosition = 0L;
    int bytesPerSample = 2;

    public WAVFileWriter(RandomAccessFile file) throws IOException {
        super(file);
    }

    public void writeIntLittle(int n) throws IOException {
        this.write(n & 0xFF);
        this.write(n >> 8 & 0xFF);
        this.write(n >> 16 & 0xFF);
        this.write(n >> 24 & 0xFF);
    }

    public void writeShortLittle(short n) throws IOException {
        this.write(n & 0xFF);
        this.write(n >> 8 & 0xFF);
    }

    public void writeFormatChunk(int bitsPerSample, int channelsPerFrame, int sampleRate) throws IOException {
        this.bytesPerSample = (bitsPerSample + 7) / 8;
        this.write(102);
        this.write(109);
        this.write(116);
        this.write(32);
        this.writeIntLittle(16);
        this.writeShortLittle((short)1);
        this.writeShortLittle((short)channelsPerFrame);
        this.writeIntLittle(sampleRate);
        this.writeIntLittle(sampleRate * channelsPerFrame * this.bytesPerSample);
        this.writeShortLittle((short)(channelsPerFrame * this.bytesPerSample));
        this.writeShortLittle((short)bitsPerSample);
    }

    public void writeDataChunk(short[] samples) throws IOException {
        this.writeDataChunkHeader(samples.length * 2);
        int i = 0;
        while (i < samples.length) {
            this.writeShortLittle(samples[i]);
            ++i;
        }
    }

    public void writeDataChunkHeader(int size) throws IOException {
        this.write(100);
        this.write(97);
        this.write(116);
        this.write(97);
        this.dataSizePosition = this.getFilePointer();
        this.writeIntLittle(size);
    }

    public void writeHeader(int size) throws IOException {
        this.write(82);
        this.write(73);
        this.write(70);
        this.write(70);
        this.riffSizePosition = this.getFilePointer();
        this.writeIntLittle(size);
        this.write(87);
        this.write(65);
        this.write(86);
        this.write(69);
    }

    public void writeHeader(int channelsPerFrame, int sampleRate) throws IOException {
        this.writeHeader(0);
        this.writeFormatChunk(16, channelsPerFrame, sampleRate);
        this.writeDataChunkHeader(0);
    }

    public void fixSizes() throws IOException {
        long end = this.getFilePointer();
        int riffSize = (int)(end - this.riffSizePosition) - 4;
        this.seek(this.riffSizePosition);
        this.writeIntLittle(riffSize);
        int dataSize = (int)(end - this.dataSizePosition) - 4;
        this.seek(this.dataSizePosition);
        this.writeIntLittle(dataSize);
    }

    public void write(short[] samples, int channelsPerFrame, int sampleRate) throws IOException {
        int formSize = 4 + (8 + samples.length * 2) + 24;
        this.writeHeader(formSize);
        this.writeFormatChunk(16, channelsPerFrame, sampleRate);
        this.writeDataChunk(samples);
    }

    void test1() throws IOException {
        int FRAME_RATE = 44100;
        int NUM_SAMPLES = 441000;
        short[] data = new short[441000];
        short phase = 0;
        int i = 0;
        while (i < 441000) {
            data[i] = phase;
            phase = (short)(phase + 456);
            ++i;
        }
        this.write(data, 1, 44100);
    }

    void test2() throws IOException {
        int FRAME_RATE = 44100;
        int NUM_SAMPLES = 1000;
        short[] data = new short[1000];
        short phase = 0;
        int i = 0;
        while (i < 1000) {
            data[i] = phase;
            phase = (short)(phase + 512);
            ++i;
        }
        this.writeHeader(1, 44100);
        i = 0;
        while (i < 1) {
            int k = 0;
            while (k < 1000) {
                this.write((byte)data[k]);
                this.write((byte)(data[k] >> 8));
                ++k;
            }
            ++i;
        }
        this.fixSizes();
    }

    public static void main(String[] args) {
        try {
            RandomAccessFile rfile = new RandomAccessFile("testout.wav", "rw");
            WAVFileWriter app = new WAVFileWriter(rfile);
            app.test2();
            app.close();
            System.out.println("Wrote testout.wav");
        }
        catch (IOException e) {
            System.err.println(e);
        }
        System.exit(0);
    }
}

