/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import java.awt.TextArea;

public class QA_Tools {
    TextArea report;
    int numErrors = 0;
    int numSuccesses = 0;

    QA_Tools(TextArea report) {
        this.report = report;
        if (report != null) {
            report.setEditable(false);
        }
    }

    void print(String msg) {
        if (this.report == null) {
            System.out.print(msg);
        } else {
            this.report.appendText(msg);
        }
    }

    void println(String msg) {
        this.print(String.valueOf(msg) + "\n");
    }

    void printSuccess(String msg) {
        this.println("SUCCESS: " + msg);
        ++this.numSuccesses;
    }

    void printError(String msg) {
        this.println("ERROR: " + msg);
        ++this.numErrors;
    }

    void printSummary() {
        this.print("Summary: " + this.numSuccesses + " successes, " + this.numErrors + " errors.");
    }

    boolean matchDoubles(double actual, double expected, double tolerance) {
        return Math.abs(actual - expected) < Math.abs(expected * tolerance);
    }
}

