/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.DualInTwoOutUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TwoInDualOutUnit;
import junit.framework.TestCase;

public class QA_Math
extends TestCase {
    MultiplyUnit multUnit;

    @Override
    protected void setUp() {
        try {
            Synth.startEngine(0);
            this.multUnit = new MultiplyUnit();
            this.multUnit.start();
        }
        catch (SynthException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void tearDown() {
        try {
            Synth.stopEngine();
        }
        catch (SynthException e) {
            e.printStackTrace();
        }
    }

    boolean matchDoubles(double actual, double expected, double tolerance) {
        return Math.abs(actual - expected) < Math.abs(expected * tolerance);
    }

    void checkMultiply(double a, double b) throws SynthException {
        double c = a * b;
        this.multUnit.inputA.set(a);
        this.multUnit.inputB.set(b);
        Synth.sleepForTicks(20);
        double answer = this.multUnit.output.get();
        QA_Math.assertTrue(this.matchDoubles(answer, c, 1.0E-5));
    }

    public void testMultiply() {
        this.checkMultiply(0.5, 0.8);
        this.checkMultiply(-1.0, 0.333);
        this.checkMultiply(-0.9, -0.8);
        this.checkMultiply(0.678, -0.8);
    }

    public void testDualIn() {
        DualInTwoOutUnit dualIn = new DualInTwoOutUnit();
        dualIn.start();
        dualIn.input.set(2.3, 0);
        dualIn.input.set(7.9, 1);
        Synth.sleepForTicks(20);
        QA_Math.assertTrue(this.matchDoubles(dualIn.outputA.get(), 2.3, 1.0E-5));
        QA_Math.assertTrue(this.matchDoubles(dualIn.outputB.get(), 7.9, 1.0E-5));
        dualIn.stop();
    }

    public void testDualOut() {
        TwoInDualOutUnit dualOut = new TwoInDualOutUnit();
        dualOut.start();
        dualOut.inputA.set(5.4);
        dualOut.inputB.set(1.7);
        Synth.sleepForTicks(20);
        QA_Math.assertTrue(this.matchDoubles(dualOut.output.get(0), 5.4, 1.0E-5));
        QA_Math.assertTrue(this.matchDoubles(dualOut.output.get(1), 1.7, 1.0E-5));
        dualOut.stop();
    }
}

