/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.tuna;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.NoiseModSwoop;
import com.softsynth.jsyn.examples.tuna.MelodicSequence;
import com.softsynth.jsyn.examples.tuna.TunaRiff;
import java.awt.Panel;

class TunaSwoop
extends TunaRiff {
    NoiseModSwoop unitSwoop;

    public TunaSwoop(Panel panel, SynthBusInput bus, double ampl) throws SynthException {
        super(panel, "NoiseModSwoop", bus, new NoiseModSwoop(), ampl);
        this.unitSwoop = (NoiseModSwoop)this.unitNote;
    }

    @Override
    public boolean play(int time, MelodicSequence melody) throws SynthException {
        boolean ifChange = super.play(time, melody);
        if (this.playBox.getState()) {
            double rate = 4.0 * Synth.getTickRate() / (double)melody.getTicksPerBeat();
            this.unitNote.note(time, 2, rate, this.ampl);
        }
        return ifChange;
    }
}

