/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.pinwheels;

import com.softsynth.jsyn.view102.XYController;
import java.awt.Graphics;

class XYPointDisplay
extends XYController {
    double[] xData;
    double[] yData;
    int numValues;
    int radius = 8;

    public XYPointDisplay(double[] xData, double[] yData) {
        this.setArrays(xData, yData);
    }

    public void setArrays(double[] xData, double[] yData) {
        this.xData = xData;
        this.yData = yData;
        this.numValues = xData.length;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.bounds().width;
        int height = this.bounds().height;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(this.getForeground());
        int x1 = this.convertWXtoGX(this.xData[0]);
        int y1 = this.convertWYtoGY(this.yData[0]);
        int i = 1;
        while (i < this.numValues) {
            g.fillOval(x1 - this.radius, y1 - this.radius, this.radius * 2, this.radius * 2);
            int x2 = this.convertWXtoGX(this.xData[i]);
            int y2 = this.convertWYtoGY(this.yData[i]);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
            ++i;
        }
        g.fillOval(x1 - this.radius, y1 - this.radius, this.radius * 2, this.radius * 2);
    }
}

