/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.pinwheels;

import com.softsynth.jsyn.examples.pinwheels.XYPointDisplay;
import com.softsynth.jsyn.view102.CustomFader;
import com.softsynth.jsyn.view102.CustomFaderListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;

class ContourSpinner
extends Panel
implements Runnable,
CustomFaderListener {
    int numPoints;
    double[] xData;
    double[] yData;
    double[] xSortedData;
    double[] ySortedData;
    XYPointDisplay xyDisplay;
    Thread spinThread;
    boolean go = false;
    CustomFader speedBar;
    Button randomButton;
    double rotationalIncrement = 0.0;
    static final int SPEED_LEVELS = 20;

    public ContourSpinner(int numPoints) {
        this.numPoints = numPoints;
        this.xData = new double[numPoints];
        this.yData = new double[numPoints];
        this.xSortedData = new double[numPoints];
        this.ySortedData = new double[numPoints];
        this.makeRandomPoints(numPoints);
        this.setLayout(new BorderLayout());
        this.xyDisplay = new XYPointDisplay(this.xSortedData, this.ySortedData);
        this.add((Component)this.xyDisplay, "Center");
        Panel panel = new Panel();
        this.add((Component)panel, "South");
        panel.setLayout(new GridLayout(0, 1));
        this.speedBar = new CustomFader(0, 20, 1, 0, 40);
        panel.add(this.speedBar);
        this.speedBar.addCustomFaderListener(this);
        this.randomButton = new Button("Random");
        panel.add(this.randomButton);
        this.xyDisplay.setMinWorldX(-1.0);
        this.xyDisplay.setMaxWorldX(1.0);
        this.xyDisplay.setMinWorldY(-1.0);
        this.xyDisplay.setMaxWorldY(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPoint(int index, double x, double y) {
        double[] dArray = this.xData;
        synchronized (this.xData) {
            this.xData[index] = x;
            this.yData[index] = y;
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    void makeRandomPoints(int numPoints) {
        double range = 1.0 / Math.sqrt(2.0);
        int i = 0;
        while (i < numPoints) {
            this.xData[i] = Math.random() * 2.0 * range - range;
            this.yData[i] = Math.random() * 2.0 * range - range;
            ++i;
        }
        this.sortDataByX();
        if (this.xyDisplay != null) {
            this.xyDisplay.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortDataByX() {
        double[] dArray = this.xData;
        synchronized (this.xData) {
            int j = 0;
            while (j < this.xData.length) {
                double xnew = this.xData[j];
                int place = 0;
                while (place < j) {
                    if (xnew < this.xSortedData[place]) break;
                    ++place;
                }
                int i = j;
                while (i > place) {
                    this.xSortedData[i] = this.xSortedData[i - 1];
                    this.ySortedData[i] = this.ySortedData[i - 1];
                    --i;
                }
                this.xSortedData[place] = xnew;
                this.ySortedData[place] = this.yData[j];
                ++j;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getSortedXY() {
        double[] dArray = this.xData;
        synchronized (this.xData) {
            double[] dar = new double[2 * this.xData.length];
            int i = 0;
            while (i < this.xData.length) {
                dar[i * 2] = this.xSortedData[i];
                dar[i * 2 + 1] = this.ySortedData[i];
                ++i;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return dar;
        }
    }

    boolean keepRunning() {
        return Thread.currentThread() == this.spinThread;
    }

    public synchronized void start() {
        System.out.println("start: got semaphore ");
        if (this.spinThread == null) {
            this.spinThread = new Thread(this);
            this.go = true;
            this.spinThread.start();
        } else {
            System.err.println("start() - thread already started!");
        }
    }

    public synchronized void stop() {
        this.go = false;
        this.spinThread = null;
    }

    public void rotatePoints(double angle) {
        if (angle == 0.0) {
            return;
        }
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        int i = 0;
        while (i < this.xData.length) {
            double x = this.xData[i];
            double y = this.yData[i];
            this.xData[i] = x * cos - y * sin;
            this.yData[i] = x * sin + y * cos;
            ++i;
        }
        this.sortDataByX();
        this.xyDisplay.repaint();
    }

    @Override
    public void run() {
        while (this.go) {
            this.rotatePoints(this.rotationalIncrement);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
        }
    }

    @Override
    public void customFaderValueChanged(Object jsb, int value) {
        if (jsb == this.speedBar) {
            int val = value - 20;
            this.rotationalIncrement = (double)(val * val) * -0.001;
            if (val < 0) {
                this.rotationalIncrement = -this.rotationalIncrement;
            }
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.randomButton) {
            this.makeRandomPoints(this.numPoints);
            this.repaint();
            Runtime.getRuntime().gc();
            return true;
        }
        return false;
    }
}

