/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TableOscillator;
import com.softsynth.jsyn.util.HarmonicTable;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.WaveDisplay;
import com.softsynth.jsyn.view11x.WaveMaker;
import com.softsynth.jsyn.view11x.WaveTrace;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

public class TJ_WaveMaker
extends Applet {
    HarmonicTable myTable;
    TableOscillator myWaveOsc;
    LineOut myOut;
    static final int WAVE_LENGTH = 512;
    static final int NUM_HARMONICS = 12;
    WaveMaker maker;
    WaveDisplay display;

    public static void main(String[] args) {
        TJ_WaveMaker applet = new TJ_WaveMaker();
        AppletFrame frame = new AppletFrame("Test WaveMaker", applet);
        frame.resize(600, 700);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.myWaveOsc = new TableOscillator();
            this.myOut = new LineOut();
            this.myTable = new HarmonicTable(513, 12);
            this.display = new WaveDisplay();
            this.display.setBackground(Color.blue);
            this.display.resize(600, 400);
            this.add(this.display);
            this.maker = new WaveMaker(this.myTable, this.display);
            this.display.addTrace(new WaveTrace(this.myTable.data, Color.white, 1.0));
            this.add(this.maker);
            this.myWaveOsc.tablePort.setTable(this.myTable);
            this.myWaveOsc.output.connect(0, this.myOut.input, 0);
            this.myWaveOsc.output.connect(0, this.myOut.input, 1);
            Panel faderPanel = new Panel();
            faderPanel.setLayout(new GridLayout(0, 1));
            faderPanel.add(new ExponentialPortFader(this.myWaveOsc.amplitude, 0.8, 0.001, 1.0));
            faderPanel.add(new ExponentialPortFader(this.myWaveOsc.frequency, 200.0, 40.0, 2000.0));
            this.add(faderPanel);
            this.getParent().validate();
            this.getToolkit().sync();
            this.myOut.start();
            this.myWaveOsc.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.myOut.stop();
            this.myWaveOsc.stop();
            this.removeAll();
            this.myOut.delete();
            this.myOut = null;
            this.myWaveOsc.delete();
            this.myWaveOsc = null;
            this.myTable.delete();
            this.myTable = null;
            this.maker = null;
            this.display = null;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

