/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineIn;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.examples.Recorder;
import java.applet.Applet;
import java.awt.Component;

public class TJ_Recorder
extends Applet {
    LineIn lineIn;
    LineOut lineOut;
    static final int NUM_CHANNELS = 1;
    static final double RECORD_TIME = 5.0;
    static final double FRAME_RATE = 22050.0;
    MyRecorder recorder;

    public static void main(String[] args) {
        TJ_Recorder applet = new TJ_Recorder();
        AppletFrame frame = new AppletFrame("Record and Playback Sound.", applet);
        frame.resize(500, 200);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.requestVersion(142);
            Synth.initialize();
            this.lineIn = new LineIn();
            this.lineOut = new LineOut();
            this.recorder = new MyRecorder(5.0, 22050.0, 1);
            this.lineIn.output.connect(0, this.recorder.input, 0);
            this.recorder.output.connect(0, this.lineOut.input, 0);
            this.recorder.output.connect(0, this.lineOut.input, 1);
            this.add(this.recorder.buildGUI());
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        this.lineOut.delete();
        this.lineOut = null;
        this.removeAll();
        Synth.setTrace(0);
        Synth.terminate();
    }

    class MyRecorder
    extends Recorder {
        public MyRecorder(double seconds, double frameRate, int numChannels) {
            super(seconds, frameRate, numChannels);
        }

        @Override
        public void record(boolean ifLoop) {
            try {
                Synth.start(96, this.frameRate);
                TJ_Recorder.this.lineIn.start();
                super.record(ifLoop);
            }
            catch (SynthException e) {
                SynthAlert.showError(e);
            }
        }

        @Override
        public void play(boolean ifLoop) {
            try {
                Synth.start(0, this.frameRate);
                TJ_Recorder.this.lineOut.start();
                super.play(ifLoop);
            }
            catch (SynthException e) {
                SynthAlert.showError(e);
            }
        }

        @Override
        public void stop() {
            super.stop();
            TJ_Recorder.this.lineIn.stop();
            TJ_Recorder.this.lineOut.stop();
            Synth.stop();
        }
    }
}

