/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;
import com.softsynth.jsyn.circuits.MultiTapDelay;
import com.softsynth.jsyn.examples.GrainFarm;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import com.softsynth.jsyn.view11x.UsageDisplay;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

public class TJ_Grains
extends Applet {
    static final int NUM_GRAINS = 4;
    GrainFarm rain;
    MultiTapDelay myReverb;
    LineOut myOut;
    SynthScope scope;

    public static void main(String[] args) {
        TJ_Grains applet = new TJ_Grains();
        AppletFrame frame = new AppletFrame("Test Grains", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.startEngine(0);
            SynthObject.enableTracking(true);
            Synth.verbosity = 0;
            double[] delays = new double[]{0.457, 0.719, 0.901, 1.0, 1.17};
            double[] gains = new double[]{0.1, -0.3, -0.2, 0.1, 0.3};
            this.myReverb = new MultiTapDelay(delays, gains);
            this.rain = new GrainFarm(4);
            this.myOut = new LineOut();
            this.rain.output.connect(this.myReverb.input);
            this.rain.output.connect(0, this.myOut.input, 0);
            this.myReverb.output.connect(0, this.myOut.input, 1);
            Panel faderPanel = new Panel();
            faderPanel.setLayout(new GridLayout(0, 1));
            faderPanel.add(new PortFader(this.rain.probability, 0.001, 0.0, 0.01));
            faderPanel.add(new ExponentialPortFader(this.rain.frequency, 280.0, 50.0, 2000.0));
            faderPanel.add(new ExponentialPortFader(this.rain.spread, 120.0, 50.0, 2000.0));
            faderPanel.add(new PortFader(this.rain.grainSpeed, 120.0, 0.0, 500.0));
            faderPanel.add(new PortFader(this.rain.amplitude, 0.9, 0.0, 1.0));
            faderPanel.add(new PortFader(this.myReverb.feedback, 0.4, 0.0, 1.0));
            faderPanel.add(new UsageDisplay());
            this.add("North", faderPanel);
            this.scope = new SynthScope(512);
            this.add("Center", this.scope);
            this.scope.createProbe(this.rain.grains[0].parabola.output, "Env[0]", Color.yellow);
            this.scope.createProbe(this.rain.grains[1].parabola.output, "Env[1]", Color.red);
            this.scope.createProbe(this.rain.grains[2].parabola.output, "Env[2]", Color.cyan);
            this.scope.createProbe(this.rain.grains[3].parabola.output, "Env[3]", Color.green);
            this.scope.createProbe(this.rain.output, "Output", Color.white);
            this.scope.finish();
            this.scope.hideControls();
            this.myOut.start();
            this.myReverb.start();
            this.rain.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.myOut.stop();
            this.rain.stop();
            this.rain.delete();
            this.rain = null;
            this.myOut.delete();
            this.myOut = null;
            this.scope = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

