/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.PortFader;
import com.softsynth.jsyn.view102.UsageDisplay;
import com.softsynth.tools.view.JAppletFrame;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;

public class TJ_Env2
extends JApplet {
    SynthEnvelope myEnvData;
    EnvelopePlayer myEnv;
    int numFrames;
    final int MAX_FRAMES = 16;
    SineOscillator myOsc;
    LineOut myOut;
    JButton hitme;
    JButton attackButton;
    JButton releaseButton;
    JButton framesButton;
    JLabel framesLabel;

    public static void main(String[] args) {
        TJ_Env2 applet = new TJ_Env2();
        JAppletFrame frame = new JAppletFrame("Test SynthEnvelope", applet);
        frame.setSize(440, 200);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            double[] data = new double[]{0.05, 1.0, 0.3, 0.1, 0.5, 0.7, 0.5, 0.9, 0.8, 0.0};
            this.numFrames = data.length / 2;
            this.myEnvData = new SynthEnvelope(this.numFrames);
            this.myEnvData.write(0, data, 0, this.numFrames);
            this.myEnv = new EnvelopePlayer();
            this.myOsc = new SineOscillator();
            this.myOut = new LineOut();
            this.myEnv.output.connect(0, this.myOsc.amplitude, 0);
            this.myOsc.output.connect(0, this.myOut.input, 0);
            this.myOsc.output.connect(0, this.myOut.input, 1);
            this.hitme = new JButton("Hit");
            this.add(this.hitme);
            this.hitme.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Env2.this.myEnv.envelopePort.clear();
                    TJ_Env2.this.myEnv.envelopePort.queue(TJ_Env2.this.myEnvData, 0, TJ_Env2.this.numFrames, 16);
                    TJ_Env2.this.myEnv.start();
                }
            });
            this.attackButton = new JButton("Attack");
            this.add(this.attackButton);
            this.attackButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Env2.this.myEnv.envelopePort.clear();
                    TJ_Env2.this.myEnv.envelopePort.queue(TJ_Env2.this.myEnvData, 0, 3);
                    TJ_Env2.this.myEnv.envelopePort.queueLoop(TJ_Env2.this.myEnvData, 1, 2);
                    TJ_Env2.this.myEnv.start();
                }
            });
            this.releaseButton = new JButton("Release");
            this.add(this.releaseButton);
            this.releaseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Env2.this.myEnv.envelopePort.queue(TJ_Env2.this.myEnvData, 3, 2, 16);
                }
            });
            this.framesButton = new JButton("Query Frames");
            this.add(this.framesButton);
            this.framesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int numFrames = TJ_Env2.this.myEnv.envelopePort.getNumFramesMoved();
                    TJ_Env2.this.framesLabel.setText("Frames played = " + numFrames);
                }
            });
            this.framesLabel = new JLabel("Frames Played = ");
            this.add(this.framesLabel);
            this.add(new PortFader(this.myEnv.rate, 1.0, 0.0, 2.0));
            this.add(new PortFader(this.myOsc.frequency, 400.0, 50.0, 2000.0));
            this.add(new UsageDisplay());
            this.myOut.start();
            this.myOsc.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.myOut.delete();
            this.myOut = null;
            this.myOsc.delete();
            this.myOsc = null;
            this.myEnv.delete();
            this.myEnv = null;
            this.removeAll();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

