/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.SampleReader;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.util.SampleQueueOutputStream;

class SawtoothStreamer
extends SynthCircuit
implements Runnable {
    SampleReader mySampler;
    static final int FRAMES_PER_BLOCK = 400;
    static final int FRAMES_IN_BUFFER = 8192;
    int numChannels = 1;
    int samplesPerBlock;
    short[] data;
    double phaseIncr = 0.02;
    double phase = 0.0;
    double freqScalar = 1.01;
    SampleQueueOutputStream outStream;
    Thread thread;
    SynthInput amplitude;

    public SawtoothStreamer() {
        if (this.numChannels == 1) {
            this.mySampler = new SampleReader_16F1();
        } else if (this.numChannels == 2) {
            this.mySampler = new SampleReader_16F2();
        } else {
            throw new RuntimeException("This example only support mono or stereo!");
        }
        this.add(this.mySampler);
        this.samplesPerBlock = 400 * this.numChannels;
        this.data = new short[this.samplesPerBlock];
        this.amplitude = this.mySampler.amplitude;
        this.addPort(this.amplitude);
        this.outStream = new SampleQueueOutputStream(this.mySampler.samplePort, 8192, this.numChannels);
    }

    public SynthOutput getOutput() {
        return this.mySampler.output;
    }

    @Override
    public void run() {
        try {
            while (this.thread != null) {
                this.sendBuffer();
            }
        }
        catch (SynthException e) {
            System.out.println("run() caught " + e);
        }
    }

    void sendBuffer() {
        int i = 0;
        while (i < this.samplesPerBlock) {
            double tri = this.phase > 0.0 ? 1.0 - 2.0 * this.phase : 1.0 + 2.0 * this.phase;
            this.data[i++] = (short)(tri * 32767.0);
            if (this.numChannels > 1) {
                this.data[i++] = (short)(this.phase * 8000.0);
            }
            this.phase += this.phaseIncr;
            if (!(this.phase > 1.0)) continue;
            this.phase -= 2.0;
        }
        this.phaseIncr *= this.freqScalar;
        double SCALAR = 0.99;
        if (this.phaseIncr > 0.02) {
            this.freqScalar = 0.99;
        } else if (this.phaseIncr < 0.002) {
            this.freqScalar = 1.0101010101010102;
        }
        this.outStream.write(this.data, 0, 400);
    }

    void startStream() {
        while (this.outStream.available() > 400) {
            this.sendBuffer();
        }
        int time = Synth.getTickCount() + 4;
        this.mySampler.start(time);
        this.outStream.start(time);
        this.thread = new Thread(this);
        this.thread.start();
    }

    void stopStream() {
        this.thread = null;
        System.out.println("Wait for flush().");
        this.outStream.flush();
        System.out.println("flush() done.");
        int time = Synth.getTickCount();
        this.mySampler.stop(time);
        this.outStream.stop(time);
    }
}

