/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.SampleReader;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.jsyn.util.SampleQueueOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class SampleFileStreamer
extends SynthCircuit
implements Runnable {
    public SynthSample mySamp;
    SampleReader mySampler;
    static final int FRAMES_PER_BLOCK = 400;
    static final int FRAMES_IN_BUFFER = 8192;
    int numChannels = 1;
    int samplesPerBlock;
    short[] data;
    SampleQueueOutputStream outStream;
    Thread thread;
    SynthInput amplitude;
    File sampleFile;
    InputStream inStream;
    int numFrames;
    int frameCursor;

    public SampleFileStreamer(File file) throws IOException {
        this.sampleFile = file;
        FileInputStream stream = new FileInputStream(file);
        this.setup(stream);
    }

    private void setup(InputStream stream) throws IOException {
        BufferedInputStream bufStream = new BufferedInputStream(stream);
        this.mySamp = new SynthSampleWAV();
        this.mySamp.load(bufStream, false);
        this.mySamp.dump();
        bufStream.close();
        this.numChannels = this.mySamp.getChannelsPerFrame();
        this.numFrames = this.mySamp.getNumFrames();
        if (this.numChannels == 1) {
            this.mySampler = new SampleReader_16F1();
        } else if (this.numChannels == 2) {
            this.mySampler = new SampleReader_16F2();
        } else {
            throw new RuntimeException("This example only supports mono or stereo!");
        }
        this.add(this.mySampler);
        this.samplesPerBlock = 400 * this.numChannels;
        this.data = new short[this.samplesPerBlock];
        this.amplitude = this.mySampler.amplitude;
        this.addPort(this.amplitude);
        this.outStream = new SampleQueueOutputStream(this.mySampler.samplePort, 8192, this.numChannels);
    }

    public SynthOutput getOutput() {
        return this.mySampler.output;
    }

    @Override
    public void run() {
        try {
            try {
                while (this.thread != null) {
                    if (this.sendBuffer() > 0) continue;
                    break;
                }
            }
            finally {
                this.outStream.flush();
                this.inStream.close();
            }
        }
        catch (IOException e) {
            System.out.println("run() caught " + e);
        }
        catch (SynthException e) {
            System.out.println("run() caught " + e);
        }
    }

    int sendBuffer() throws IOException {
        int samplesToRead = this.samplesPerBlock;
        int framesLeft = this.numFrames - this.frameCursor;
        int samplesLeft = framesLeft * this.numChannels;
        if (samplesToRead > samplesLeft) {
            samplesToRead = samplesLeft;
        }
        int i = 0;
        while (i < samplesToRead) {
            int sample = this.inStream.read();
            if (sample < 0) {
                throw new IOException("Premature EOF");
            }
            sample = this.inStream.read() << 8 | sample & 0xFF;
            this.data[i++] = (short)sample;
        }
        if (i > 0) {
            int framesRead = i / this.numChannels;
            this.frameCursor += framesRead;
            this.outStream.write(this.data, 0, framesRead);
        }
        return framesLeft;
    }

    void startStream() {
        try {
            FileInputStream fileStream = new FileInputStream(this.sampleFile);
            this.inStream = new BufferedInputStream(fileStream);
            this.inStream.skip(this.mySamp.getOffset());
            this.frameCursor = 0;
            while (this.outStream.available() > 400) {
                this.sendBuffer();
            }
            int time = Synth.getTickCount() + 4;
            this.mySampler.start(time);
            this.outStream.start(time);
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (IOException exc) {
            System.err.println(exc.toString());
        }
    }

    void stopStream() {
        Thread myThread = this.thread;
        if (this.thread != null) {
            this.thread = null;
            try {
                myThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int time = Synth.getTickCount();
            this.outStream.stop(time);
            this.mySampler.stop(time);
        }
    }
}

