/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.SampleReader;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.SampleWriter;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSample;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class Recorder {
    public SynthInput input;
    public SynthOutput output;
    public static final int STOPPED = 0;
    public static final int PLAYING = 1;
    public static final int RECORDING = 2;
    SynthSample sample;
    SampleWriter sampleWriter;
    SampleReader sampleReader;
    Button recordButton;
    Button playButton;
    Button stopButton;
    Checkbox loopBox;
    double frameRate;
    int mode;

    public Recorder(double seconds, double frameRate, int numChannels) {
        this.frameRate = frameRate;
        this.sample = new SynthSample((int)(frameRate * seconds), numChannels);
        switch (numChannels) {
            case 1: {
                this.sampleWriter = new SampleWriter_16F1();
                this.sampleReader = new SampleReader_16F1();
                break;
            }
            case 2: {
                this.sampleWriter = new SampleWriter_16F2();
                this.sampleReader = new SampleReader_16F2();
                break;
            }
            default: {
                throw new SynthException("Only support 1 or 2 channel recording.");
            }
        }
        this.input = this.sampleWriter.input;
        this.output = this.sampleReader.output;
    }

    public Panel buildGUI() {
        Panel panel = new Panel();
        this.recordButton = new Button("Record");
        panel.add(this.recordButton);
        this.recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Recorder.this.record(Recorder.this.loopBox.getState());
            }
        });
        this.stopButton = new Button("Stop");
        panel.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Recorder.this.stop();
            }
        });
        this.playButton = new Button("Play");
        panel.add(this.playButton);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Recorder.this.play(Recorder.this.loopBox.getState());
            }
        });
        this.loopBox = new Checkbox("Loop");
        panel.add(this.loopBox);
        return panel;
    }

    void setMode(int mode) {
        this.mode = mode;
        switch (mode) {
            case 0: {
                this.recordButton.setEnabled(true);
                this.playButton.setEnabled(true);
                this.stopButton.setEnabled(false);
                break;
            }
            case 1: 
            case 2: {
                this.recordButton.setEnabled(false);
                this.playButton.setEnabled(false);
                this.stopButton.setEnabled(true);
            }
        }
    }

    public void record(boolean ifLoop) {
        this.sampleWriter.start();
        if (ifLoop) {
            this.sampleWriter.samplePort.queueLoop(this.sample);
        } else {
            this.sampleWriter.samplePort.queue(this.sample);
        }
        this.setMode(2);
    }

    public void play(boolean ifLoop) {
        this.sampleReader.start();
        if (ifLoop) {
            this.sampleReader.samplePort.queueLoop(this.sample);
        } else {
            this.sampleReader.samplePort.queue(this.sample);
        }
        this.setMode(1);
    }

    public void stop() {
        this.sampleWriter.samplePort.clear();
        this.sampleWriter.stop();
        this.sampleReader.samplePort.clear();
        this.sampleReader.stop();
        this.setMode(0);
    }
}

