/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.StateVariableFilter;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.WhiteNoise;

public class CrossSVFilter
extends SynthNote {
    WhiteNoise myNoise = new WhiteNoise();
    StateVariableFilter myFilter1;
    StateVariableFilter myFilter2;
    MultiplyUnit myModIndex;
    MultiplyAddUnit myCtlMix1;
    MultiplyAddUnit myCtlMix2;
    public SynthInput noiseAmp;
    public SynthInput modIndex;
    public SynthDistributor resonance;
    public SynthDistributor modDepth;

    public CrossSVFilter() throws SynthException {
        this.add(this.myNoise);
        this.myFilter1 = new StateVariableFilter();
        this.add(this.myFilter1);
        this.myFilter2 = new StateVariableFilter();
        this.add(this.myFilter2);
        this.myModIndex = new MultiplyUnit();
        this.add(this.myModIndex);
        this.myCtlMix1 = new MultiplyAddUnit();
        this.add(this.myCtlMix1);
        this.myCtlMix2 = new MultiplyAddUnit();
        this.add(this.myCtlMix2);
        this.noiseAmp = this.myNoise.amplitude;
        this.addPort(this.noiseAmp, "noiseAmp");
        this.modIndex = this.myModIndex.inputB;
        this.addPort(this.modIndex, "modIndex");
        this.amplitude = this.myFilter1.amplitude;
        this.addPort(this.amplitude);
        this.output = this.myFilter1.output;
        this.addPort(this.output);
        this.frequency = new SynthDistributor(this, "frequency", 6);
        this.modDepth = new SynthDistributor(this, "modDepth", 6);
        this.resonance = new SynthDistributor(this, "resonance");
        this.modDepth.connect(this.myCtlMix1.inputB);
        this.modDepth.connect(this.myCtlMix2.inputB);
        this.frequency.connect(this.myCtlMix1.inputC);
        this.frequency.connect(this.myModIndex.inputA);
        this.resonance.connect(this.myFilter1.resonance);
        this.resonance.connect(this.myFilter2.resonance);
        this.myNoise.output.connect(this.myFilter1.input);
        this.myNoise.output.connect(this.myFilter2.input);
        this.myFilter1.lowPass.connect(this.myCtlMix2.inputA);
        this.myFilter2.lowPass.connect(this.myCtlMix1.inputA);
        this.myModIndex.output.connect(this.myCtlMix2.inputC);
        this.myCtlMix1.output.connect(this.myFilter1.frequency);
        this.myCtlMix2.output.connect(this.myFilter2.frequency);
        this.noiseAmp.setup(0.0, 0.1, 0.8);
        this.modIndex.setup(0.0, 0.6, 1.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
        this.frequency.setup(0.0, 700.0, 1000.0);
        this.modDepth.setup(0.0, 8000.0, 10000.0);
        this.resonance.setup(0.0, 0.05, 0.3);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                this.stop(time);
                this.start(time);
            }
        }
    }
}

