/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.bridge;

import com.jsyn.unitgen.AsymptoticRamp;
import com.jsyn.unitgen.CrossFade;
import com.jsyn.unitgen.FilterStateVariable;
import com.jsyn.unitgen.FilterTwoPolesTwoZeros;
import com.jsyn.unitgen.FixedRateMonoWriter;
import com.jsyn.unitgen.FixedRateStereoWriter;
import com.jsyn.unitgen.FourWayFade;
import com.jsyn.unitgen.FunctionEvaluator;
import com.jsyn.unitgen.FunctionOscillator;
import com.jsyn.unitgen.ImpulseOscillator;
import com.jsyn.unitgen.ImpulseOscillatorBL;
import com.jsyn.unitgen.Latch;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.Pan;
import com.jsyn.unitgen.PanControl;
import com.jsyn.unitgen.ParabolicEnvelope;
import com.jsyn.unitgen.PeakFollower;
import com.jsyn.unitgen.PulseOscillator;
import com.jsyn.unitgen.PulseOscillatorBL;
import com.jsyn.unitgen.RedNoise;
import com.jsyn.unitgen.SawtoothOscillator;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SawtoothOscillatorDPW;
import com.jsyn.unitgen.Select;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SquareOscillator;
import com.jsyn.unitgen.SquareOscillatorBL;
import com.jsyn.unitgen.TriangleOscillator;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.softsynth.jsyn.bridge.AddUnsigned;
import com.softsynth.jsyn.bridge.FilterStateVariableOld;
import com.softsynth.jsyn.bridge.MultiplyAddUnsigned;
import com.softsynth.jsyn.bridge.MultiplyUnsigned;
import com.softsynth.jsyn.bridge.SampleReader16V1;
import com.softsynth.jsyn.bridge.SampleReader16V2;
import java.util.HashMap;

public class SignalTypeLookup {
    private static HashMap<String, Integer> signalMap = new HashMap();
    private static int CSYN_SIGNAL_TYPE_RAW_SIGNED = 0;
    private static int CSYN_SIGNAL_TYPE_RAW_UNSIGNED = 1;
    private static int CSYN_SIGNAL_TYPE_OSC_FREQ = 2;
    private static int CSYN_SIGNAL_TYPE_SAMPLE_RATE = 3;
    private static int CSYN_SIGNAL_TYPE_HALF_LIFE = 4;
    private static int CSYN_SIGNAL_TYPE_TIME = 5;
    private static int CSYN_SIGNAL_TYPE_SVF_FREQ = 6;
    private static int CSYN_SIGNAL_TYPE_FULL_RANGE = 7;
    private static String[] typeNames = new String[]{"CSYN_SIGNAL_TYPE_RAW_SIGNED", "CSYN_SIGNAL_TYPE_RAW_UNSIGNED", "CSYN_SIGNAL_TYPE_OSC_FREQ", "CSYN_SIGNAL_TYPE_SAMPLE_RATE", "CSYN_SIGNAL_TYPE_HALF_LIFE", "CSYN_SIGNAL_TYPE_TIME", "CSYN_SIGNAL_TYPE_SVF_FREQ", "CSYN_SIGNAL_TYPE_FULL_RANGE"};

    static {
        SignalTypeLookup.addSignalType(AddUnsigned.class, "InputA", CSYN_SIGNAL_TYPE_RAW_UNSIGNED);
        SignalTypeLookup.addSignalType(AddUnsigned.class, "InputB", CSYN_SIGNAL_TYPE_RAW_UNSIGNED);
        SignalTypeLookup.addSignalType(CrossFade.class, "Fade", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(VariableRateMonoReader.class, "Rate", CSYN_SIGNAL_TYPE_RAW_UNSIGNED);
        SignalTypeLookup.addSignalType(AsymptoticRamp.class, "HalfLife", CSYN_SIGNAL_TYPE_HALF_LIFE);
        SignalTypeLookup.addSignalType(FilterTwoPolesTwoZeros.class, "A0", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterTwoPolesTwoZeros.class, "A1", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterTwoPolesTwoZeros.class, "A2", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterTwoPolesTwoZeros.class, "B1", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterTwoPolesTwoZeros.class, "B2", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterStateVariable.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterStateVariable.class, "Resonance", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterStateVariable.class, "Amplitude", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FourWayFade.class, "Fade", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FourWayFade.class, "Fade", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(ImpulseOscillator.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(ImpulseOscillatorBL.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(ImpulseOscillatorBL.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(Latch.class, "Gate", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(LineOut.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(LineOut.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(LinearRamp.class, "Time", CSYN_SIGNAL_TYPE_TIME);
        SignalTypeLookup.addSignalType(MultiplyAddUnsigned.class, "InputA", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(MultiplyAddUnsigned.class, "InputB", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(MultiplyAddUnsigned.class, "InputC", CSYN_SIGNAL_TYPE_RAW_UNSIGNED);
        SignalTypeLookup.addSignalType(MultiplyUnsigned.class, "InputA", CSYN_SIGNAL_TYPE_RAW_UNSIGNED);
        SignalTypeLookup.addSignalType(MultiplyUnsigned.class, "InputB", CSYN_SIGNAL_TYPE_RAW_UNSIGNED);
        SignalTypeLookup.addSignalType(PanControl.class, "Pan", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(Pan.class, "Pan", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(ParabolicEnvelope.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(ParabolicEnvelope.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(PeakFollower.class, "HalfLife", CSYN_SIGNAL_TYPE_HALF_LIFE);
        SignalTypeLookup.addSignalType(PulseOscillator.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(PulseOscillator.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(PulseOscillator.class, "Width", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(PulseOscillatorBL.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(PulseOscillatorBL.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(PulseOscillatorBL.class, "Width", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(RedNoise.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(RedNoise.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(SampleReader16V1.class, "Rate", CSYN_SIGNAL_TYPE_SAMPLE_RATE);
        SignalTypeLookup.addSignalType(SampleReader16V2.class, "Rate", CSYN_SIGNAL_TYPE_SAMPLE_RATE);
        SignalTypeLookup.addSignalType(FixedRateMonoWriter.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FixedRateStereoWriter.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FixedRateStereoWriter.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(SawtoothOscillator.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(SawtoothOscillator.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(SawtoothOscillatorBL.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(SawtoothOscillatorBL.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(SawtoothOscillatorDPW.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(SawtoothOscillatorDPW.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(Select.class, "Select", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(SineOscillator.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(SineOscillator.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(SquareOscillator.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(SquareOscillator.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(SquareOscillatorBL.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(SquareOscillatorBL.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterStateVariableOld.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterStateVariableOld.class, "Resonance", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FilterStateVariableOld.class, "Frequency", CSYN_SIGNAL_TYPE_SVF_FREQ);
        SignalTypeLookup.addSignalType(FilterStateVariableOld.class, "Amplitude", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FunctionOscillator.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(FunctionOscillator.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(TriangleOscillator.class, "Frequency", CSYN_SIGNAL_TYPE_OSC_FREQ);
        SignalTypeLookup.addSignalType(TriangleOscillator.class, "Phase", CSYN_SIGNAL_TYPE_RAW_SIGNED);
        SignalTypeLookup.addSignalType(FunctionEvaluator.class, "Input", CSYN_SIGNAL_TYPE_RAW_SIGNED);
    }

    private static void addSignalType(Class<?> clazz, String portName, int signalType) {
        String key = SignalTypeLookup.makeKey(clazz, portName);
        signalMap.put(key, signalType);
    }

    private static String makeKey(Class<?> clazz, String portName) {
        return String.valueOf(clazz.getName()) + ", " + portName;
    }

    public static int getSignalType(Class<?> clazz, String portName) {
        String key = SignalTypeLookup.makeKey(clazz, portName);
        Integer signalInteger = signalMap.get(key);
        if (signalInteger == null) {
            return CSYN_SIGNAL_TYPE_FULL_RANGE;
        }
        return signalInteger;
    }

    public static void generateCode(Class<? extends UnitGenerator> clazz, String portName, int signalType) {
        if (signalType != CSYN_SIGNAL_TYPE_FULL_RANGE) {
            System.out.format("\t\taddSignalType( %s.class, \"%s\", %s );\n", clazz.getName(), portName, typeNames[signalType]);
        }
    }
}

