/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.SignalChecker;
import com.softsynth.jsyn.Synth;
import junit.framework.TestCase;

public class TestStateVariableFilters
extends TestCase {
    private static final int SAMPLE_SIZE = 128;
    private static final double OSC_FREQ = 900.0;
    static short[] imageSVF;

    static {
        short[] sArray = new short[128];
        sArray[25] = 64;
        sArray[26] = 128;
        sArray[27] = 191;
        sArray[28] = 252;
        sArray[29] = 312;
        sArray[30] = 370;
        sArray[31] = 426;
        sArray[32] = 480;
        sArray[33] = 532;
        sArray[34] = 581;
        sArray[35] = 627;
        sArray[36] = 671;
        sArray[37] = 712;
        sArray[38] = 749;
        sArray[39] = 784;
        sArray[40] = 815;
        sArray[41] = 842;
        sArray[42] = 866;
        sArray[43] = 887;
        sArray[44] = 903;
        sArray[45] = 916;
        sArray[46] = 926;
        sArray[47] = 931;
        sArray[48] = 933;
        sArray[49] = 931;
        sArray[50] = 926;
        sArray[51] = 917;
        sArray[52] = 904;
        sArray[53] = 888;
        sArray[54] = 869;
        sArray[55] = 847;
        sArray[56] = 821;
        sArray[57] = 792;
        sArray[58] = 760;
        sArray[59] = 726;
        sArray[60] = 689;
        sArray[61] = 650;
        sArray[62] = 608;
        sArray[63] = 565;
        sArray[64] = 519;
        sArray[65] = 472;
        sArray[66] = 423;
        sArray[67] = 373;
        sArray[68] = 322;
        sArray[69] = 271;
        sArray[70] = 218;
        sArray[71] = 165;
        sArray[72] = 112;
        sArray[73] = 59;
        sArray[74] = 71;
        sArray[75] = 82;
        sArray[76] = 92;
        sArray[77] = 103;
        sArray[78] = 112;
        sArray[79] = 122;
        sArray[80] = 130;
        sArray[81] = 138;
        sArray[82] = 146;
        sArray[83] = 153;
        sArray[84] = 159;
        sArray[85] = 164;
        sArray[86] = 169;
        sArray[87] = 173;
        sArray[88] = 177;
        sArray[89] = 179;
        sArray[90] = 181;
        sArray[91] = 183;
        sArray[92] = 183;
        sArray[93] = 183;
        sArray[94] = 182;
        sArray[95] = 180;
        sArray[96] = 178;
        sArray[97] = 175;
        sArray[98] = 171;
        sArray[99] = 167;
        sArray[100] = 162;
        sArray[101] = 156;
        sArray[102] = 150;
        sArray[103] = 144;
        sArray[104] = 137;
        sArray[105] = 129;
        sArray[106] = 121;
        sArray[107] = 112;
        sArray[108] = 103;
        sArray[109] = 94;
        sArray[110] = 85;
        sArray[111] = 75;
        sArray[112] = 65;
        sArray[113] = 55;
        sArray[114] = 45;
        sArray[115] = 34;
        sArray[116] = 24;
        sArray[117] = 13;
        sArray[118] = 3;
        sArray[119] = -6;
        sArray[120] = -16;
        sArray[121] = -27;
        sArray[122] = -36;
        sArray[123] = 17;
        sArray[124] = 72;
        sArray[125] = 125;
        sArray[126] = 178;
        sArray[127] = 229;
        imageSVF = sArray;
    }

    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testLowPass() {
        this.check(imageSVF, 440.0f, 0.13f);
    }

    private void check(short[] image, float freq, float resonance) {
        Filter_StateVariable filter1 = new Filter_StateVariable();
        Filter_StateVariable filter2 = new Filter_StateVariable();
        ImpulseOscillator osc = new ImpulseOscillator();
        osc.frequency.set(900.0);
        osc.amplitude.set(0.5);
        osc.start();
        this.setupFilter(filter1, freq, resonance);
        osc.output.connect(filter1.input);
        SignalChecker checker = new SignalChecker(Synth.getSharedContext());
        if (image == null) {
            this.setupFilter(filter2, freq, resonance);
            osc.output.connect(filter2.input);
            osc.phase.set(0.0);
            image = new short[128];
            filter2.start();
            checker.record(filter2.output, image);
            checker.dumpSource(image);
        }
        filter1.start();
        osc.phase.set(0.0);
        checker.compare(filter1.output, image);
    }

    private void setupFilter(Filter_StateVariable filter, float freq, float resonance) {
        filter.frequency.set(freq);
        filter.resonance.set(resonance);
    }
}

