/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthEnvelopeQueue;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import junit.framework.TestCase;

public class TestRaceConditions
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(0);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void checkCircuit() {
        SimpleCircuit circuit = new SimpleCircuit();
        double dur = 75.0 / Synth.getFrameRate();
        double[] data = new double[]{dur, 0.7, dur, 0.3};
        SynthEnvelope envelope = new SynthEnvelope(data);
        circuit.a.set(3.0);
        circuit.b.set(4.0);
        circuit.envelopePort.queue(envelope, 0, 1);
        circuit.start();
        if (Math.random() < 0.2) {
            Runtime.getRuntime().gc();
        }
    }

    public void testOneThread() {
        BangOnCircuit banger = new BangOnCircuit();
        banger.start();
        try {
            Thread.sleep(1000L);
            banger.go = false;
            banger.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkManyThreads(int numThreads) {
        BangOnCircuit[] bangers = new BangOnCircuit[numThreads];
        int i = 0;
        while (i < numThreads) {
            bangers[i] = new BangOnCircuit();
            bangers[i].start();
            ++i;
        }
        try {
            Thread.sleep(5000L);
            i = 0;
            while (i < numThreads) {
                bangers[i].go = false;
                ++i;
            }
            i = 0;
            while (i < numThreads) {
                bangers[i].join(1000L);
                TestRaceConditions.assertTrue("Banger ended with exception. Did not set passed to true.", bangers[i].passed);
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void testManyThreads() {
        this.checkManyThreads(50);
    }

    class BangOnCircuit
    extends Thread {
        volatile boolean go = true;
        boolean passed = false;

        BangOnCircuit() {
        }

        @Override
        public void run() {
            while (this.go) {
                TestRaceConditions.this.checkCircuit();
            }
            this.passed = true;
        }
    }

    class SimpleCircuit
    extends SynthCircuit {
        AddUnit adder;
        EnvelopePlayer envPlayer = new EnvelopePlayer();
        SynthInput a;
        SynthInput b;
        SynthOutput output;
        SynthOutput envOutput;
        SynthEnvelopeQueue envelopePort;

        public SimpleCircuit() {
            this.adder = new AddUnit();
            this.add(this.adder);
            this.envPlayer = new EnvelopePlayer();
            this.add(this.envPlayer);
            this.a = this.adder.inputA;
            this.addPort(this.a, "A");
            this.b = this.adder.inputB;
            this.addPort(this.b, "B");
            this.output = this.adder.output;
            this.addPort(this.output);
            this.envOutput = this.envPlayer.output;
            this.addPort(this.envOutput);
            this.envelopePort = this.envPlayer.envelopePort;
            this.addPort(this.envelopePort);
        }
    }
}

