/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthScalarPort;
import com.softsynth.jsyn.SynthSound;

public class SynthVariable
extends SynthScalarPort {
    double min;
    double max;
    double lastValue = 0.0;
    static double[] mins = new double[8];
    static double[] maxs = new double[8];

    static {
        SynthVariable.mins[0] = -1.0;
        SynthVariable.maxs[0] = 1.0;
        SynthVariable.mins[1] = 0.0;
        SynthVariable.maxs[1] = 2.0;
        SynthVariable.mins[2] = 0.0;
        SynthVariable.maxs[2] = 10000.0;
        SynthVariable.mins[3] = 0.0;
        SynthVariable.maxs[3] = 88200.0;
        SynthVariable.mins[4] = 0.001;
        SynthVariable.maxs[4] = 10.0;
        SynthVariable.mins[5] = 0.0;
        SynthVariable.maxs[5] = 20.0;
        SynthVariable.mins[6] = 0.0;
        SynthVariable.maxs[6] = 10000.0;
        SynthVariable.mins[7] = -100000.0;
        SynthVariable.maxs[7] = 100000.0;
    }

    SynthVariable(SynthSound sound, String name) throws SynthException {
        super(sound, name);
        int type = this.getSignalType();
        this.setMinMaxByType(type);
    }

    @Override
    public void setSignalType(int signalType, int partIndex) throws SynthException {
        super.setSignalType(signalType, partIndex);
    }

    void setMinMaxByType(int signalType) {
        this.min = mins[signalType];
        this.max = maxs[signalType];
    }

    public void setAt(int time, int partIndex, double value) throws SynthException {
        this.set(time, value, partIndex);
    }

    public void setAt(int time, double value) throws SynthException {
        this.set(time, value, 0);
    }

    public void set(int time, double value, int partIndex) throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthVariable.set(" + time + ", " + Integer.toHexString(this.peerToken) + ", " + this.name + ", " + partIndex + ", " + value + ")");
        }
        if ((nativeError = this.sound.context.setPortAt(time, this.peerToken, this.portHash, partIndex, value)) < 0) {
            throw new SynthException(nativeError, this.name, this.peerToken, partIndex);
        }
        this.lastValue = value;
    }

    public void set(int time, double value) throws SynthException {
        this.set(time, value, 0);
    }

    public void set(double value, int partIndex) throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthVariable.set(" + Integer.toHexString(this.peerToken) + ", " + this.name + ", " + partIndex + ", " + value + ")");
        }
        if ((nativeError = this.sound.context.setPort(this.peerToken, this.portHash, partIndex, value)) < 0) {
            throw new SynthException(nativeError, this.name, this.peerToken, partIndex);
        }
        this.lastValue = value;
    }

    public void set(double value) throws SynthException {
        this.set(value, 0);
    }

    @Override
    public double get(int partIndex) throws SynthException {
        return this.lastValue;
    }

    public double getCurrent(int partIndex) throws SynthException {
        return super.get(partIndex);
    }

    public double getCurrent() {
        return this.getCurrent(0);
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    public void setup(double min, double value, double max) throws SynthException {
        this.setMin(min);
        this.setMax(max);
        this.set(value);
    }
}

