/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSound;
import java.util.Vector;

public class SynthCircuit
extends SynthSound {
    public SynthOutput output = null;
    Vector sounds;
    int flags = 0;

    public SynthCircuit(SynthContext synthContext, int numSounds) throws SynthException {
        super(synthContext);
        this.sounds = new Vector(numSounds);
    }

    public SynthCircuit(SynthContext synthContext) throws SynthException {
        this(synthContext, 8);
    }

    public SynthCircuit(int numSounds) throws SynthException {
        this(Synth.getSharedContext(), numSounds);
    }

    public SynthCircuit() throws SynthException {
        this(8);
    }

    public synchronized void add(SynthSound sound) throws SynthException {
        if (this.peerToken != 0) {
            throw new SynthException(-200, 0);
        }
        this.sounds.addElement(sound);
    }

    @Override
    public int getPeer() throws SynthException {
        if (this.peerToken == 0) {
            this.compile();
        }
        return super.getPeer();
    }

    public synchronized void compile() throws SynthException {
        if (this.peerToken != 0) {
            return;
        }
        int numUnits = this.sounds.size();
        int[] peerArray = new int[numUnits];
        int i = 0;
        while (i < numUnits) {
            SynthSound sound = (SynthSound)this.sounds.elementAt(i);
            peerArray[i] = sound.getPeer();
            if (Synth.verbosity >= 2) {
                System.out.println("SynthCircuit.compile: ( " + sound.getName() + ", " + Integer.toHexString(sound.peerToken));
            }
            ++i;
        }
        this.peerToken = this.context.createCircuit(peerArray, this.flags);
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, "Circuit", numUnits);
        }
        if (Synth.verbosity >= 1) {
            System.out.println("SynthCircuit.compiled => " + this);
        }
    }

    @Override
    public synchronized void delete() throws SynthException {
        int lastIndex;
        this.output = null;
        while ((lastIndex = this.sounds.size() - 1) >= 0) {
            SynthSound sobj = (SynthSound)this.sounds.elementAt(lastIndex);
            this.sounds.removeElementAt(lastIndex);
            sobj.delete();
        }
        super.delete();
    }

    public static synchronized SynthCircuit loadByName(String name) {
        Class<?> lbc;
        SynthCircuit circ = null;
        try {
            lbc = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            System.err.println(" Error finding " + name + " = " + e);
            return null;
        }
        try {
            circ = (SynthCircuit)lbc.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println(" Error instantiating " + name + " = " + e);
            return null;
        }
        catch (IllegalAccessException e) {
            System.err.println(" Error loading " + name + " = " + e);
            return null;
        }
        return circ;
    }
}

