/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.install;

import com.softsynth.install.Installer;
import com.softsynth.install.InstallerGUI;
import java.io.File;

public class PlatformChecker {
    InstallerGUI gui;

    public PlatformChecker(InstallerGUI gui2) {
        this.gui = gui2;
    }

    private double extractFirstDouble(String osv) {
        int secondAt;
        int firstAt = osv.indexOf(46);
        if (firstAt >= 0 && (secondAt = osv.indexOf(46, firstAt + 1)) >= 0) {
            osv = osv.substring(0, secondAt);
        }
        double result = 0.0;
        try {
            result = Double.valueOf(osv);
        }
        catch (NumberFormatException exc) {
            exc.printStackTrace();
        }
        return result;
    }

    protected double getOSVersionDouble() {
        return this.extractFirstDouble(System.getProperty("os.version"));
    }

    protected double getJavaVersionDouble() {
        return this.extractFirstDouble(System.getProperty("java.version"));
    }

    String checkVersionSupport(String defaultNativeLibrary) {
        String finalNativeLibrary = defaultNativeLibrary;
        double javaVersion = this.getJavaVersionDouble();
        double osVersion = this.getOSVersionDouble();
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String javaVendor = System.getProperty("java.vendor");
        if (javaVersion < 1.1) {
            this.barfOnPlatform("Java version less than 1.1!");
        } else if (osName != null) {
            if (osName.startsWith("Windows")) {
                if (osName.indexOf("Vista") >= 0) {
                    throw new RuntimeException("Windows Vista does not support automatic installation. See link below.");
                }
                if (javaVendor.indexOf("Microsoft") >= 0) {
                    this.barfOnPlatform("Microsoft Java. Please install Sun Java from www.java.com.");
                }
                if (javaVendor.indexOf("Netscape") >= 0) {
                    this.barfOnPlatform("Netscape Java. Please install Firefox browser from www.firefox.com.");
                }
            } else if (!osName.startsWith("Linux") && osName.startsWith("Mac")) {
                if (osVersion < 10.3) {
                    this.barfOnPlatform("Mac OS 10.2 or earlier!");
                } else if (osVersion == 10.3) {
                    if (osArch.indexOf("i386") >= 0) {
                        this.barfOnPlatform("Intel Macs running OS 10.3");
                    } else {
                        this.gui.println("Using special version for PPC Mac OS 10.3");
                        finalNativeLibrary = String.valueOf(defaultNativeLibrary) + "_PPC_103";
                    }
                }
                this.checkMacExtensionFolder();
            }
        }
        return finalNativeLibrary;
    }

    private void checkMacExtensionFolder() {
        File extensionDir = Installer.getMacUserExtensionFolder();
        if (extensionDir != null) {
            if (extensionDir.isDirectory()) {
                this.gui.println("The \"" + extensionDir + "\" folder exists.");
            } else if (!extensionDir.mkdirs()) {
                this.barfOnPlatform("Mac that did not allow creation of " + extensionDir);
            } else {
                this.gui.println("Created \"" + extensionDir + "\" folder required for Java plugins.");
                String msg = "IMPORTANT: It is necessary to RESTART the browser before continuing installation!";
                this.gui.showMessage(msg);
                this.gui.println("Please completely Quit the browser by selecting Quit from the browser File menu.");
                this.gui.println("Then return to this page to continue installation.");
                throw new RuntimeException(msg);
            }
        }
    }

    private void barfOnPlatform(String platform) {
        String msg = "JSyn not supported for " + platform;
        this.gui.println(msg);
        throw new RuntimeException(msg);
    }

    public String checkVersionSupport() {
        return this.checkVersionSupport("nolib");
    }
}

