/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.install;

import com.softsynth.install.Installer;
import com.softsynth.install.InstallerGUI;
import com.softsynth.install.PlatformChecker;
import java.io.IOException;

public class InstallJSyn
extends Installer {
    private int versionToInstall = 144;
    private static final String JSYN_JAR_NAME = "jsyn.jar";
    private static final String BUILD = "018";
    private static final String ARCHIVE_URL = "http://www.softsynth.com/jsyn/plugins/archives";
    private String jsynLibNameForPlatform;

    public InstallJSyn(InstallerGUI gui, int pVersionToInstall) {
        super(gui);
        this.versionToInstall = pVersionToInstall;
        gui.println("jsyn.installer.build = 018");
    }

    String getLibName() {
        return "JSynV" + this.versionToInstall;
    }

    int getJarCount() {
        return this.countExistingInstallations(System.getProperty("java.ext.dirs"), JSYN_JAR_NAME);
    }

    public void install(boolean installJAR) throws IOException {
        PlatformChecker checker = new PlatformChecker(this.gui);
        this.jsynLibNameForPlatform = checker.checkVersionSupport(this.getLibName());
        if (this.getJarCount() == 0 || installJAR) {
            this.installJar(JSYN_JAR_NAME, ARCHIVE_URL);
        }
        this.installNativeLibrary(this.jsynLibNameForPlatform, this.getLibName(), ARCHIVE_URL);
    }
}

