/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.ezxml;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentingWriter
extends PrintWriter {
    private String indentationText = "   ";
    private int indentationLevel = 0;
    private int column = 0;

    public IndentingWriter(OutputStream stream) {
        super(stream, true);
    }

    public IndentingWriter(PrintWriter writer) {
        super((Writer)writer, true);
    }

    public void setIndentation(int level) {
        this.indentationLevel = level;
    }

    public int getIndentation() {
        return this.indentationLevel;
    }

    public void indent() {
        ++this.indentationLevel;
    }

    public void undent() {
        --this.indentationLevel;
        if (this.indentationLevel < 0) {
            this.indentationLevel = 0;
        }
    }

    @Override
    public void print(String s) {
        if (this.column == 0) {
            int i = 0;
            while (i < this.indentationLevel) {
                super.print(this.indentationText);
                ++i;
            }
        }
        super.print(s);
        this.column += s.length();
    }

    @Override
    public void println() {
        super.println();
        this.column = 0;
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void newLine() {
        if (this.column > 0) {
            this.println();
        }
    }

    public void wrapAt(int margin) {
        if (this.column > margin) {
            this.println();
        }
    }

    public String getIndentationText() {
        return this.indentationText;
    }

    public void setIndentationText(String indentationText) {
        this.indentationText = indentationText;
    }
}

