/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.Instrument;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;

public class VoiceAllocator
implements Instrument {
    private int maxVoices;
    private VoiceTracker[] trackers;
    private long tick;
    private Synthesizer synthesizer;
    private int presetIndex = -1;

    public VoiceAllocator(UnitVoice[] voices) {
        this.maxVoices = voices.length;
        this.trackers = new VoiceTracker[this.maxVoices];
        int i = 0;
        while (i < this.maxVoices) {
            this.trackers[i] = new VoiceTracker();
            this.trackers[i].voice = voices[i];
            ++i;
        }
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = this.trackers[0].voice.getUnitGenerator().getSynthesizer();
        }
        return this.synthesizer;
    }

    public int getVoiceCount() {
        return this.maxVoices;
    }

    private VoiceTracker findVoice(int tag) {
        VoiceTracker[] voiceTrackerArray = this.trackers;
        int n = this.trackers.length;
        int n2 = 0;
        while (n2 < n) {
            VoiceTracker tracker = voiceTrackerArray[n2];
            if (tracker.tag == tag) {
                return tracker;
            }
            ++n2;
        }
        return null;
    }

    private VoiceTracker stealVoice() {
        VoiceTracker bestOff = null;
        VoiceTracker bestOn = null;
        VoiceTracker[] voiceTrackerArray = this.trackers;
        int n = this.trackers.length;
        int n2 = 0;
        while (n2 < n) {
            VoiceTracker tracker = voiceTrackerArray[n2];
            if (tracker.voice == null) {
                return tracker;
            }
            if (bestOff != null) {
                if (!tracker.on && tracker.when < bestOff.when) {
                    bestOff = tracker;
                }
            } else if (tracker.on) {
                if (bestOn == null) {
                    bestOn = tracker;
                } else if (tracker.when < bestOn.when) {
                    bestOn = tracker;
                }
            } else {
                bestOff = tracker;
            }
            ++n2;
        }
        if (bestOff != null) {
            return bestOff;
        }
        return bestOn;
    }

    protected synchronized UnitVoice allocate(int tag) {
        VoiceTracker tracker = this.allocateTracker(tag);
        return tracker.voice;
    }

    private VoiceTracker allocateTracker(int tag) {
        VoiceTracker tracker = this.findVoice(tag);
        if (tracker == null) {
            tracker = this.stealVoice();
        }
        tracker.tag = tag;
        tracker.when = this.tick++;
        tracker.on = true;
        return tracker;
    }

    protected synchronized boolean isOn(int tag) {
        VoiceTracker tracker = this.findVoice(tag);
        if (tracker != null) {
            return tracker.on;
        }
        return false;
    }

    protected synchronized UnitVoice off(int tag) {
        VoiceTracker tracker = this.findVoice(tag);
        if (tracker != null) {
            tracker.off();
            return tracker.voice;
        }
        return null;
    }

    @Override
    public void allNotesOff(TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker[] voiceTrackerArray = VoiceAllocator.this.trackers;
                int n = voiceTrackerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VoiceTracker tracker = voiceTrackerArray[n2];
                    if (tracker.on) {
                        tracker.voice.noteOff(VoiceAllocator.this.getSynthesizer().createTimeStamp());
                        tracker.off();
                    }
                    ++n2;
                }
            }
        });
    }

    @Override
    public void noteOn(final int tag, final double frequency, final double amplitude, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.allocateTracker(tag);
                if (VoiceAllocator.this.presetIndex != voiceTracker.presetIndex) {
                    voiceTracker.voice.usePreset(VoiceAllocator.this.presetIndex);
                }
                voiceTracker.voice.noteOn(frequency, amplitude, VoiceAllocator.this.getSynthesizer().createTimeStamp());
            }
        });
    }

    @Override
    public void noteOff(final int tag, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.findVoice(tag);
                if (voiceTracker != null) {
                    voiceTracker.voice.noteOff(VoiceAllocator.this.getSynthesizer().createTimeStamp());
                    VoiceAllocator.this.off(tag);
                }
            }
        });
    }

    @Override
    public void setPort(final int tag, final String portName, final double value, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.findVoice(tag);
                if (voiceTracker != null) {
                    voiceTracker.voice.setPort(portName, value, VoiceAllocator.this.getSynthesizer().createTimeStamp());
                }
            }
        });
    }

    @Override
    public void usePreset(final int presetIndex, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker[] voiceTrackerArray = VoiceAllocator.this.trackers;
                int n = voiceTrackerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VoiceTracker tracker = voiceTrackerArray[n2];
                    tracker.voice.usePreset(presetIndex);
                    ++n2;
                }
            }
        });
    }

    private class VoiceTracker {
        UnitVoice voice;
        int tag = -1;
        int presetIndex = -1;
        long when;
        boolean on;

        private VoiceTracker() {
        }

        public void off() {
            this.on = false;
            VoiceAllocator voiceAllocator = VoiceAllocator.this;
            long l = voiceAllocator.tick;
            voiceAllocator.tick = l + 1L;
            this.when = l;
        }
    }
}

