/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.tutorial;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.PortFader;
import com.softsynth.jsyn.view102.SynthScope;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

public class TUT_SineMix
extends Applet {
    SineOscillator sineOsc1;
    SineOscillator sineOsc2;
    AddUnit mixer;
    LineOut lineOut;
    PortFader freqFader1;
    PortFader ampFader1;
    PortFader freqFader2;
    PortFader ampFader2;
    SynthScope scope;

    public static void main(String[] args) {
        TUT_SineMix applet = new TUT_SineMix();
        AppletFrame frame = new AppletFrame("Test JSyn", applet);
        frame.resize(500, 550);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraint = new GridBagConstraints();
        this.setLayout(gridbag);
        constraint.fill = 1;
        constraint.weightx = 1.0;
        try {
            Synth.startEngine(0);
            this.sineOsc1 = new SineOscillator();
            this.sineOsc2 = new SineOscillator();
            this.mixer = new AddUnit();
            this.lineOut = new LineOut();
            this.sineOsc1.output.connect(this.mixer.inputA);
            this.sineOsc2.output.connect(this.mixer.inputB);
            this.mixer.output.connect(0, this.lineOut.input, 0);
            this.mixer.output.connect(0, this.lineOut.input, 1);
            this.sineOsc1.amplitude.set(0.0);
            this.sineOsc2.amplitude.set(0.0);
            this.lineOut.start();
            this.mixer.start();
            this.sineOsc1.start();
            this.sineOsc2.start();
            constraint.gridheight = 1;
            constraint.gridwidth = 0;
            constraint.weighty = 0.0;
            this.freqFader1 = new PortFader(this.sineOsc1.frequency, 440.0, 0.0, 500.0);
            this.add(this.freqFader1);
            gridbag.setConstraints(this.freqFader1, constraint);
            this.ampFader1 = new PortFader(this.sineOsc1.amplitude, 0.0, 0.0, 1.0);
            this.add(this.ampFader1);
            gridbag.setConstraints(this.ampFader1, constraint);
            this.freqFader2 = new PortFader(this.sineOsc2.frequency, 330.0, 0.0, 500.0);
            this.add(this.freqFader2);
            gridbag.setConstraints(this.freqFader2, constraint);
            this.ampFader2 = new PortFader(this.sineOsc2.amplitude, 0.0, 0.0, 1.0);
            this.add(this.ampFader2);
            gridbag.setConstraints(this.ampFader2, constraint);
            this.scope = new SynthScope();
            this.add(this.scope);
            this.scope.createProbe(this.sineOsc1.output, "Sine 1", Color.red);
            this.scope.createProbe(this.sineOsc2.output, "Sine 2", Color.green);
            this.scope.createProbe(this.mixer.output, "Mixed", Color.yellow);
            this.scope.finish();
            constraint.gridheight = -1;
            constraint.weighty = 1.0;
            gridbag.setConstraints(this.scope, constraint);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

