/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.research;

import java.util.ArrayList;
import junit.framework.TestCase;

public class BenchMultiThreading
extends TestCase {
    private static final int FRAMES_PER_BLOCK = 64;
    int numThreads = 4;
    int numLoops = 100000;
    private ArrayList<CustomThread> threadList;

    public void testMultiThreads() {
        this.threadList = new ArrayList();
        int i = 0;
        while (i < this.numThreads) {
            CustomThread thread = new CustomThread();
            this.threadList.add(thread);
            thread.start();
            ++i;
        }
        long frameCount = 0L;
        long startTime = System.currentTimeMillis();
        try {
            int i2 = 0;
            while (i2 < this.numLoops) {
                this.waitForThreads(++frameCount);
                ++i2;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        double elapsedSeconds = 0.001 * (double)elapsedTime;
        double blocksPerSecond = (double)this.numLoops / elapsedSeconds;
        System.out.format("blocksPerSecond = %10.3f\n", blocksPerSecond);
        double framesPerSecond = blocksPerSecond * 64.0;
        System.out.format("audio framesPerSecond = %10.3f at %d frames per block\n", framesPerSecond, 64);
        for (CustomThread thread : this.threadList) {
            System.out.format("max elapsed time is %d nanos or %f msec\n", thread.maxElapsed, (double)thread.maxElapsed / 1000000.0);
        }
        for (CustomThread thread : this.threadList) {
            BenchMultiThreading.assertEquals("BlockCount must match ", frameCount, thread.frameCount);
            thread.abort();
        }
    }

    private void waitForThreads(long frameCount) throws InterruptedException {
        for (CustomThread thread : this.threadList) {
            thread.generateFrame(frameCount);
        }
        for (CustomThread thread : this.threadList) {
            thread.waitForFrame(frameCount);
        }
    }

    class CustomThread
    extends Thread {
        long frameCount = 0L;
        long desiredFrame = 0L;
        Object semaphore = new Object();
        Object goSemaphore = new Object();
        volatile boolean go = true;
        long startNano;
        long stopNano;
        long maxElapsed;

        CustomThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startNano = System.nanoTime();
                while (this.go) {
                    this.stopNano = System.nanoTime();
                    long elapsed = this.stopNano - this.startNano;
                    this.startNano = System.nanoTime();
                    if (elapsed > this.maxElapsed) {
                        this.maxElapsed = elapsed;
                    }
                    Object object = this.semaphore;
                    synchronized (object) {
                        ++this.frameCount;
                        this.semaphore.notify();
                    }
                    object = this.goSemaphore;
                    synchronized (object) {
                        while (this.desiredFrame <= this.frameCount) {
                            this.goSemaphore.wait();
                        }
                    }
                    long l = System.nanoTime();
                }
            }
            catch (InterruptedException e) {
                System.out.println("CustomThread interrupted. ");
            }
            System.out.println("Finishing " + this);
        }

        public void abort() {
            this.go = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForFrame(long targetFrame) throws InterruptedException {
            Object object = this.semaphore;
            synchronized (object) {
                while (this.frameCount < targetFrame) {
                    this.semaphore.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateFrame(long desiredFrame) {
            Object object = this.goSemaphore;
            synchronized (object) {
                this.desiredFrame = desiredFrame;
                this.goSemaphore.notify();
            }
        }
    }
}

