/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.scope.AudioScope;
import com.jsyn.scope.AudioScopeProbe;
import com.jsyn.swing.ExponentialRangeModel;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortModelFactory;
import com.jsyn.swing.RotaryTextController;
import com.jsyn.unitgen.FilterFourPoles;
import com.jsyn.unitgen.FilterLowPass;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class HearMoogFilter
extends JApplet {
    private Synthesizer synth;
    private UnitOscillator oscillator;
    private FilterFourPoles filterMoog;
    private FilterLowPass filterBiquad;
    private LinearRamp rampCutoff;
    private PassThrough tieQ;
    private PassThrough mixer;
    private LineOut lineOut;
    private AudioScope scope;
    private AudioScopeProbe moogProbe;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.oscillator = new SawtoothOscillatorBL();
        this.synth.add(this.oscillator);
        this.rampCutoff = new LinearRamp();
        this.synth.add(this.rampCutoff);
        this.tieQ = new PassThrough();
        this.synth.add(this.tieQ);
        this.filterMoog = new FilterFourPoles();
        this.synth.add(this.filterMoog);
        this.filterBiquad = new FilterLowPass();
        this.synth.add(this.filterBiquad);
        this.mixer = new PassThrough();
        this.synth.add(this.mixer);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.oscillator.output.connect(this.filterMoog.input);
        this.oscillator.output.connect(this.filterBiquad.input);
        this.rampCutoff.output.connect(this.filterMoog.frequency);
        this.rampCutoff.output.connect(this.filterBiquad.frequency);
        this.rampCutoff.time.set(0.05);
        this.tieQ.output.connect(this.filterMoog.Q);
        this.tieQ.output.connect(this.filterBiquad.Q);
        this.filterMoog.output.connect(this.mixer.input);
        this.mixer.output.connect(0, this.lineOut.input, 0);
        this.mixer.output.connect(0, this.lineOut.input, 1);
        this.filterBiquad.amplitude.set(0.1);
        this.oscillator.frequency.setup(50.0, 130.0, 3000.0);
        this.oscillator.amplitude.setup(0.0, 0.336, 1.0);
        this.rampCutoff.input.setup(50.0, 400.0, 4000.0);
        this.tieQ.input.setup(0.1, 0.7, 10.0);
        this.setupGUI();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Sawtooth through a \"Moog\" style filter."), "North");
        JPanel rackPanel = new JPanel();
        rackPanel.setLayout(new BoxLayout(rackPanel, 1));
        JPanel buttonPanel = new JPanel();
        ButtonGroup cbg = new ButtonGroup();
        JRadioButton radioButton = new JRadioButton("Moog", true);
        cbg.add(radioButton);
        radioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((HearMoogFilter)HearMoogFilter.this).mixer.input.disconnectAll();
                ((HearMoogFilter)HearMoogFilter.this).filterMoog.output.connect(((HearMoogFilter)HearMoogFilter.this).mixer.input);
            }
        });
        buttonPanel.add(radioButton);
        radioButton = new JRadioButton("Biquad", false);
        cbg.add(radioButton);
        radioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((HearMoogFilter)HearMoogFilter.this).mixer.input.disconnectAll();
                ((HearMoogFilter)HearMoogFilter.this).filterBiquad.output.connect(((HearMoogFilter)HearMoogFilter.this).mixer.input);
            }
        });
        buttonPanel.add(radioButton);
        rackPanel.add(buttonPanel);
        JPanel knobPanel = new JPanel();
        knobPanel.setLayout(new GridLayout(1, 0));
        knobPanel.add(this.setupPortKnob(this.oscillator.frequency, "OscFreq"));
        knobPanel.add(this.setupPortKnob(this.oscillator.amplitude, "OscAmp"));
        knobPanel.add(this.setupPortKnob(this.rampCutoff.input, "Cutoff"));
        knobPanel.add(this.setupPortKnob(this.tieQ.input, "Q"));
        rackPanel.add(knobPanel);
        this.add((Component)rackPanel, "South");
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.oscillator.output);
        this.moogProbe = this.scope.addProbe(this.filterMoog.output);
        this.scope.addProbe(this.filterBiquad.output);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setControlsVisible(false);
        this.add((Component)this.scope.getView(), "Center");
        this.scope.start();
        this.validate();
    }

    private RotaryTextController setupPortKnob(UnitInputPort port, String label) {
        ExponentialRangeModel model = PortModelFactory.createExponentialModel(port);
        RotaryTextController knob = new RotaryTextController(model, 10);
        knob.setBorder(BorderFactory.createTitledBorder(label));
        knob.setTitle(label);
        return knob;
    }

    @Override
    public void start() {
        this.synth.start();
        this.scope.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.scope.stop();
        this.synth.stop();
    }

    public static void main(String[] args) {
        HearMoogFilter applet = new HearMoogFilter();
        JAppletFrame frame = new JAppletFrame("Hear Moog Style Filter", applet);
        frame.setSize(800, 600);
        frame.setVisible(true);
        frame.test();
    }
}

