/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.unitgen.ChannelIn;
import com.jsyn.unitgen.PassThrough;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JComboBox;

public class DualOscilloscope
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private ChannelIn channel1;
    private ChannelIn channel2;
    private PassThrough pass1;
    private PassThrough pass2;
    private AudioScope scope;
    private AudioDeviceManager audioManager;
    private int defaultInputId;
    private ArrayList<String> deviceNames = new ArrayList();
    private ArrayList<Integer> deviceMaxInputs = new ArrayList();
    private ArrayList<Integer> deviceIds = new ArrayList();
    private int defaultSelection;
    private JComboBox deviceComboBox;

    @Override
    public void init() {
        this.audioManager = AudioDeviceFactory.createAudioDeviceManager(true);
        this.synth = JSyn.createSynthesizer(this.audioManager);
        int numDevices = this.audioManager.getDeviceCount();
        this.defaultInputId = this.audioManager.getDefaultInputDeviceID();
        int i = 0;
        while (i < numDevices) {
            int maxInputs = this.audioManager.getMaxInputChannels(i);
            if (maxInputs > 0) {
                String deviceName = this.audioManager.getDeviceName(i);
                String itemName = String.valueOf(maxInputs) + ", " + deviceName + " (#" + i + ")";
                if (i == this.defaultInputId) {
                    this.defaultSelection = this.deviceNames.size();
                    itemName = String.valueOf(itemName) + " (Default)";
                }
                this.deviceNames.add(itemName);
                this.deviceMaxInputs.add(maxInputs);
                this.deviceIds.add(i);
            }
            ++i;
        }
        this.channel1 = new ChannelIn();
        this.synth.add(this.channel1);
        this.channel1.setChannelIndex(0);
        this.channel2 = new ChannelIn();
        this.synth.add(this.channel2);
        this.channel2.setChannelIndex(1);
        this.pass1 = new PassThrough();
        this.synth.add(this.pass1);
        this.pass2 = new PassThrough();
        this.synth.add(this.pass2);
        this.setupGUI();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.deviceComboBox = new JComboBox<String>(this.deviceNames.toArray(new String[0]));
        this.deviceComboBox.setSelectedIndex(this.defaultSelection);
        this.add((Component)this.deviceComboBox, "North");
        this.deviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualOscilloscope.this.stopAudio();
                int itemIndex = DualOscilloscope.this.deviceComboBox.getSelectedIndex();
                DualOscilloscope.this.startAudio(itemIndex);
            }
        });
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.pass1.output);
        this.scope.addProbe(this.pass2.output);
        this.scope.setTriggerMode(AudioScope.TriggerMode.AUTO);
        this.scope.getView().setControlsVisible(true);
        this.add((Component)this.scope.getView(), "Center");
        this.validate();
    }

    protected void startAudio(int itemIndex) {
        int numInputChannels = this.deviceMaxInputs.get(itemIndex);
        if (numInputChannels > 2) {
            numInputChannels = 2;
        }
        int inputDeviceIndex = this.deviceIds.get(itemIndex);
        this.synth.start(44100, inputDeviceIndex, numInputChannels, -1, 0);
        this.channel1.output.connect(this.pass1.input);
        if (numInputChannels > 1) {
            this.channel2.output.connect(this.pass2.input);
        }
        this.scope.start();
    }

    @Override
    public void start() {
        this.startAudio(this.defaultSelection);
    }

    public void stopAudio() {
        this.pass1.input.disconnectAll();
        this.pass2.input.disconnectAll();
        this.scope.stop();
        this.synth.stop();
    }

    @Override
    public void stop() {
        this.stopAudio();
    }

    public static void main(String[] args) {
        DualOscilloscope applet = new DualOscilloscope();
        JAppletFrame frame = new JAppletFrame("Dual Oscilloscope", applet);
        frame.setSize(640, 400);
        frame.setVisible(true);
        frame.test();
    }
}

