/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;
import com.jsyn.engine.LoadAnalyzer;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.ScheduledQueue;
import com.softsynth.shared.time.TimeStamp;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class SynthesisEngine
implements Runnable,
Synthesizer {
    private static final int BLOCKS_PER_BUFFER = 8;
    private static final int FRAMES_PER_BUFFER = 64;
    public static final int DEFAULT_FRAME_RATE = 44100;
    private AudioDeviceManager audioDeviceManager;
    private AudioDeviceOutputStream audioOutputStream;
    private AudioDeviceInputStream audioInputStream;
    private Thread audioThread;
    private ScheduledQueue<ScheduledCommand> commandQueue = new ScheduledQueue();
    private volatile boolean go;
    private InterleavingBuffer inputBuffer;
    private InterleavingBuffer outputBuffer;
    private double inverseNyquist;
    private long frameCount;
    private boolean pullDataEnabled = true;
    private boolean useRealTime = true;
    private boolean started;
    private int frameRate = 44100;
    private double framePeriod = 1.0 / (double)this.frameRate;
    private ArrayList<UnitGenerator> allUnitList = new ArrayList();
    private ArrayList<UnitGenerator> runningUnitList = new ArrayList();
    private ArrayList<UnitGenerator> stoppingUnitList = new ArrayList();
    private LoadAnalyzer loadAnalyzer;
    private CopyOnWriteArrayList<Runnable> audioTasks = new CopyOnWriteArrayList();
    public static final double DB96 = 1.5848931924611107E-5;
    public static final double DB90 = 3.0517578125E-5;
    static Logger logger = Logger.getLogger(SynthesisEngine.class.getName());

    public SynthesisEngine(AudioDeviceManager audioDeviceManager) {
        this.audioDeviceManager = audioDeviceManager;
    }

    public SynthesisEngine() {
        this(AudioDeviceFactory.createAudioDeviceManager());
    }

    @Override
    public String getVersion() {
        return "16.7.2";
    }

    @Override
    public int getVersionCode() {
        return 1050370;
    }

    public String toString() {
        return "JSyn " + JSyn.VERSION_TEXT;
    }

    public boolean isPullDataEnabled() {
        return this.pullDataEnabled;
    }

    public void setPullDataEnabled(boolean pullDataEnabled) {
        this.pullDataEnabled = pullDataEnabled;
    }

    private void setupAudioBuffers(int numInputChannels, int numOutputChannels) {
        this.inputBuffer = new InterleavingBuffer(64, 8, numInputChannels);
        this.outputBuffer = new InterleavingBuffer(64, 8, numOutputChannels);
    }

    public void terminate() {
    }

    @Override
    public void start() {
        this.start(44100, -1, 0, -1, 2);
    }

    @Override
    public void start(int frameRate) {
        this.start(frameRate, -1, 0, -1, 2);
    }

    @Override
    public synchronized void start(int frameRate, int inputDeviceID, int numInputChannels, int outputDeviceID, int numOutputChannels) {
        if (this.started) {
            logger.info("JSyn already started.");
            return;
        }
        this.frameRate = frameRate;
        this.framePeriod = 1.0 / (double)frameRate;
        for (UnitGenerator ugen : this.allUnitList) {
            ugen.setFrameRate(frameRate);
        }
        this.setupAudioBuffers(numInputChannels, numOutputChannels);
        logger.info("Pure Java JSyn from www.softsynth.com, rate = " + frameRate + ", " + (this.useRealTime ? "RT" : "NON-RealTime") + ", " + JSyn.VERSION_TEXT);
        this.inverseNyquist = 2.0 / (double)frameRate;
        if (this.useRealTime) {
            if (numInputChannels > 0) {
                this.audioInputStream = this.audioDeviceManager.createInputStream(inputDeviceID, frameRate, numInputChannels);
            }
            if (numOutputChannels > 0) {
                this.audioOutputStream = this.audioDeviceManager.createOutputStream(outputDeviceID, frameRate, numOutputChannels);
            }
            this.audioThread = new Thread(this);
            logger.fine("Synth thread old priority = " + this.audioThread.getPriority());
            this.audioThread.setPriority(this.audioThread.getPriority() + 2);
            logger.fine("Synth thread new priority = " + this.audioThread.getPriority());
            this.go = true;
            this.audioThread.start();
        }
        this.started = true;
    }

    @Override
    public boolean isRunning() {
        return this.go;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (!this.started) {
            logger.info("JSyn already stopped.");
            return;
        }
        if (this.useRealTime) {
            this.go = false;
            if (this.audioThread != null) {
                try {
                    this.audioThread.interrupt();
                    this.audioThread.join(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<UnitGenerator> arrayList = this.runningUnitList;
        synchronized (arrayList) {
            this.runningUnitList.clear();
        }
        this.started = false;
    }

    @Override
    public void run() {
        block15: {
            logger.fine("JSyn synthesis thread starting.");
            try {
                try {
                    String msg;
                    if (this.audioInputStream != null) {
                        logger.finer("JSyn synthesis thread trying to start audio INPUT!");
                        this.audioInputStream.start();
                        msg = String.format("Input Latency in = %5.1f msec", 1000.0 * this.audioInputStream.getLatency());
                        logger.fine(msg);
                    }
                    if (this.audioOutputStream != null) {
                        logger.finer("JSyn synthesis thread trying to start audio OUTPUT!");
                        this.audioOutputStream.start();
                        msg = String.format("Output Latency = %5.1f msec", 1000.0 * this.audioOutputStream.getLatency());
                        logger.fine(msg);
                        this.audioOutputStream.write(this.outputBuffer.interleavedBuffer);
                    }
                    this.loadAnalyzer = new LoadAnalyzer();
                    while (this.go) {
                        if (this.audioInputStream != null) {
                            this.audioInputStream.read(this.inputBuffer.interleavedBuffer);
                        }
                        this.loadAnalyzer.start();
                        this.runAudioTasks();
                        this.generateNextBuffer();
                        this.loadAnalyzer.stop();
                        if (this.audioOutputStream == null) continue;
                        this.audioOutputStream.write(this.outputBuffer.interleavedBuffer);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.go = false;
                    logger.info("JSyn synthesis thread in finally code.");
                    if (this.audioInputStream != null) {
                        this.audioInputStream.stop();
                    }
                    if (this.audioOutputStream != null) {
                        this.audioOutputStream.stop();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                logger.info("JSyn synthesis thread in finally code.");
                if (this.audioInputStream != null) {
                    this.audioInputStream.stop();
                }
                if (this.audioOutputStream != null) {
                    this.audioOutputStream.stop();
                }
                throw throwable;
            }
            logger.info("JSyn synthesis thread in finally code.");
            if (this.audioInputStream != null) {
                this.audioInputStream.stop();
            }
            if (this.audioOutputStream != null) {
                this.audioOutputStream.stop();
            }
        }
        logger.fine("JSyn synthesis thread exiting.");
    }

    private void runAudioTasks() {
        for (Runnable task : this.audioTasks) {
            task.run();
        }
    }

    public void generateNextBuffer() {
        int outIndex = 0;
        int inIndex = 0;
        int i = 0;
        while (i < 8) {
            if (this.inputBuffer != null) {
                inIndex = this.inputBuffer.deinterleave(inIndex);
            }
            TimeStamp timeStamp = this.createTimeStamp();
            this.processScheduledCommands(timeStamp);
            this.clearBlockBuffers();
            this.synthesizeBuffer();
            if (this.outputBuffer != null) {
                outIndex = this.outputBuffer.interleave(outIndex);
            }
            this.frameCount += 8L;
            ++i;
        }
    }

    @Override
    public double getCurrentTime() {
        return (double)this.frameCount * this.framePeriod;
    }

    @Override
    public TimeStamp createTimeStamp() {
        return new TimeStamp(this.getCurrentTime());
    }

    /*
     * Unable to fully structure code
     */
    private void processScheduledCommands(TimeStamp timeStamp) {
        timeList = this.commandQueue.removeNextList(timeStamp);
        ** GOTO lbl9
        {
            command = timeList.remove(0);
            SynthesisEngine.logger.fine("processing " + command + ", at time " + timeStamp.getTime());
            command.run();
            do {
                if (!timeList.isEmpty()) continue block0;
                timeList = this.commandQueue.removeNextList(timeStamp);
lbl9:
                // 2 sources

            } while (timeList != null);
        }
    }

    @Override
    public void scheduleCommand(TimeStamp timeStamp, ScheduledCommand command) {
        if (Thread.currentThread() == this.audioThread && timeStamp.getTime() <= this.getCurrentTime()) {
            command.run();
        } else {
            logger.fine("scheduling " + command + ", at time " + timeStamp.getTime());
            this.commandQueue.add(timeStamp, command);
        }
    }

    @Override
    public void scheduleCommand(double time, ScheduledCommand command) {
        TimeStamp timeStamp = new TimeStamp(time);
        this.scheduleCommand(timeStamp, command);
    }

    @Override
    public void queueCommand(ScheduledCommand command) {
        TimeStamp timeStamp = this.createTimeStamp();
        this.scheduleCommand(timeStamp, command);
    }

    private void clearBlockBuffers() {
        this.outputBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synthesizeBuffer() {
        ArrayList<UnitGenerator> arrayList = this.runningUnitList;
        synchronized (arrayList) {
            ListIterator<UnitGenerator> iterator = this.runningUnitList.listIterator();
            while (iterator.hasNext()) {
                UnitGenerator unit = iterator.next();
                if (this.pullDataEnabled) {
                    unit.pullData(this.getFrameCount(), 0, 8);
                    continue;
                }
                unit.generate(0, 8);
            }
            for (UnitGenerator ugen : this.stoppingUnitList) {
                this.runningUnitList.remove(ugen);
                ugen.flattenOutputs();
            }
        }
        this.stoppingUnitList.clear();
    }

    public double[] getInputBuffer(int i) {
        try {
            return this.inputBuffer.getChannelBuffer(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Audio Input not configured in start() method.");
        }
    }

    public double[] getOutputBuffer(int i) {
        try {
            return this.outputBuffer.getChannelBuffer(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Audio Output not configured in start() method.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStopUnit(UnitGenerator unit) {
        ArrayList<UnitGenerator> arrayList = this.runningUnitList;
        synchronized (arrayList) {
            this.runningUnitList.remove(unit);
        }
        unit.flattenOutputs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoStopUnit(UnitGenerator unitGenerator) {
        ArrayList<UnitGenerator> arrayList = this.stoppingUnitList;
        synchronized (arrayList) {
            this.stoppingUnitList.add(unitGenerator);
        }
    }

    @Override
    public void startUnit(UnitGenerator unit, double time) {
        this.startUnit(unit, new TimeStamp(time));
    }

    @Override
    public void stopUnit(UnitGenerator unit, double time) {
        this.stopUnit(unit, new TimeStamp(time));
    }

    @Override
    public void startUnit(final UnitGenerator unit, TimeStamp timeStamp) {
        if (unit.getCircuit() == null) {
            this.scheduleCommand(timeStamp, new ScheduledCommand(){

                @Override
                public void run() {
                    SynthesisEngine.this.internalStartUnit(unit);
                }
            });
        }
    }

    @Override
    public void stopUnit(final UnitGenerator unit, TimeStamp timeStamp) {
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                SynthesisEngine.this.internalStopUnit(unit);
            }
        });
    }

    @Override
    public void startUnit(UnitGenerator unit) {
        this.startUnit(unit, this.createTimeStamp());
    }

    @Override
    public void stopUnit(UnitGenerator unit) {
        this.stopUnit(unit, this.createTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStartUnit(UnitGenerator unit) {
        if (unit.getCircuit() == null) {
            ArrayList<UnitGenerator> arrayList = this.runningUnitList;
            synchronized (arrayList) {
                if (!this.runningUnitList.contains(unit)) {
                    this.runningUnitList.add(unit);
                }
            }
        }
    }

    public double getInverseNyquist() {
        return this.inverseNyquist;
    }

    public double convertTimeToExponentialScaler(double duration) {
        double numFrames = duration * (double)this.getFrameRate();
        return Math.pow(3.0517578125E-5, 1.0 / numFrames);
    }

    @Override
    public long getFrameCount() {
        return this.frameCount;
    }

    @Override
    public int getFrameRate() {
        return this.frameRate;
    }

    @Override
    public double getFramePeriod() {
        return this.framePeriod;
    }

    public static double convertShortToDouble(short sdata) {
        return (double)sdata * 3.051850947599719E-5;
    }

    public static short convertDoubleToShort(double d) {
        double maxValue = 0.999969481490524;
        if (d > 0.999969481490524) {
            d = 0.999969481490524;
        } else if (d < -1.0) {
            d = -1.0;
        }
        return (short)(d * 32767.0);
    }

    @Override
    public void addAudioTask(Runnable blockTask) {
        this.audioTasks.add(blockTask);
    }

    @Override
    public void removeAudioTask(Runnable blockTask) {
        this.audioTasks.remove(blockTask);
    }

    @Override
    public double getUsage() {
        LoadAnalyzer temp = this.loadAnalyzer;
        if (temp != null) {
            return temp.getAverageLoad();
        }
        return 0.0;
    }

    @Override
    public AudioDeviceManager getAudioDeviceManager() {
        return this.audioDeviceManager;
    }

    @Override
    public void setRealTime(boolean realTime) {
        this.useRealTime = realTime;
    }

    @Override
    public boolean isRealTime() {
        return this.useRealTime;
    }

    public double getOutputLatency() {
        if (this.audioOutputStream != null) {
            return this.audioOutputStream.getLatency();
        }
        return 0.0;
    }

    public double getInputLatency() {
        if (this.audioInputStream != null) {
            return this.audioInputStream.getLatency();
        }
        return 0.0;
    }

    @Override
    public void add(UnitGenerator ugen) {
        ugen.setSynthesisEngine(this);
        this.allUnitList.add(ugen);
        if (this.frameRate > 0) {
            ugen.setFrameRate(this.frameRate);
        }
    }

    @Override
    public void remove(UnitGenerator ugen) {
        this.allUnitList.remove(ugen);
    }

    @Override
    public void sleepUntil(double time) throws InterruptedException {
        double timeToSleep = time - this.getCurrentTime();
        while (timeToSleep > 0.0) {
            if (this.useRealTime) {
                long msecToSleep = (long)(1000.0 * timeToSleep);
                if (msecToSleep <= 0L) {
                    msecToSleep = 1L;
                }
                Thread.sleep(msecToSleep);
            } else {
                this.generateNextBuffer();
            }
            timeToSleep = time - this.getCurrentTime();
        }
    }

    @Override
    public void sleepFor(double duration) throws InterruptedException {
        this.sleepUntil(this.getCurrentTime() + duration);
    }

    public void printConnections() {
        if (this.pullDataEnabled) {
            ListIterator<UnitGenerator> iterator = this.runningUnitList.listIterator();
            while (iterator.hasNext()) {
                UnitGenerator unit = iterator.next();
                unit.printConnections();
            }
        }
    }

    class ChannelBlockBuffer {
        private double[] values;

        ChannelBlockBuffer(int framesPerBlock) {
            this.values = new double[framesPerBlock];
        }

        void clear() {
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = 0.0;
                ++i;
            }
        }
    }

    class InterleavingBuffer {
        private double[] interleavedBuffer;
        ChannelBlockBuffer[] blockBuffers;

        InterleavingBuffer(int framesPerBuffer, int framesPerBlock, int samplesPerFrame) {
            this.interleavedBuffer = new double[framesPerBuffer * samplesPerFrame];
            this.blockBuffers = new ChannelBlockBuffer[samplesPerFrame];
            int i = 0;
            while (i < this.blockBuffers.length) {
                this.blockBuffers[i] = new ChannelBlockBuffer(framesPerBlock);
                ++i;
            }
        }

        int deinterleave(int inIndex) {
            int jf = 0;
            while (jf < 8) {
                int iob = 0;
                while (iob < this.blockBuffers.length) {
                    ChannelBlockBuffer buffer = this.blockBuffers[iob];
                    ((ChannelBlockBuffer)buffer).values[jf] = this.interleavedBuffer[inIndex++];
                    ++iob;
                }
                ++jf;
            }
            return inIndex;
        }

        int interleave(int outIndex) {
            int jf = 0;
            while (jf < 8) {
                int iob = 0;
                while (iob < this.blockBuffers.length) {
                    ChannelBlockBuffer buffer = this.blockBuffers[iob];
                    this.interleavedBuffer[outIndex++] = buffer.values[jf];
                    ++iob;
                }
                ++jf;
            }
            return outIndex;
        }

        public double[] getChannelBuffer(int i) {
            return this.blockBuffers[i].values;
        }

        public void clear() {
            int i = 0;
            while (i < this.blockBuffers.length) {
                this.blockBuffers[i].clear();
                ++i;
            }
        }
    }
}

