/*
 * Decompiled with CFR 0.152.
 */
package berliner;

import berliner.BerlinerCircuit;
import berliner.BerlinerSamples;
import berliner.SampleWaveShaper;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.Tweakable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Vector;

public class BerlinerVoice
extends Panel
implements Tweakable {
    public SynthOutput output;
    static final int PRESETS_PER_SOURCE = 8;
    static final double MIN_GLIDE_FREQ = 0.001;
    static final double MAX_GLIDE_FREQ = 0.5;
    int numSources = 8;
    BerlinerCircuit ghcirc;
    Vector[] sequences;
    int sourceIndex = 0;
    Checkbox[] sourceBoxes;
    Checkbox[] presetBoxes;
    double glideDuration = 1.0;
    boolean goSeq = false;
    Button debugButton;
    LabelledFader[] faders;
    LabelledFader glideFader;

    public void start() {
        this.setLayout(new BorderLayout());
        this.numSources = BerlinerSamples.names.length;
        try {
            this.setLayout(new BorderLayout());
            this.ghcirc = new SampleWaveShaper();
            this.output = this.ghcirc.output;
            this.ghcirc.amplitude.set(0.0);
            this.add("West", this.makeSourceGrid());
            Panel faderPanel = new Panel();
            faderPanel.setLayout(new GridLayout(0, 1));
            faderPanel.add(this.makePresetGrid("Preset: ", this.numSources));
            faderPanel.add(new LabelledFader(this, 0, "Amplitude", 0.0, 0.0, 1.0));
            this.glideFader = new LabelledFader(this, 1, "Glide", 0.5, 0.0, 1.0);
            faderPanel.add(this.glideFader);
            this.faders = new LabelledFader[this.ghcirc.getNumParameters()];
            int i = 0;
            while (i < this.ghcirc.getNumParameters()) {
                this.faders[i] = new LabelledFader(this, i + 2, this.ghcirc.getParameterName(i), 0.0, 0.0, 1.0);
                faderPanel.add(this.faders[i]);
                ++i;
            }
            this.add("Center", faderPanel);
            this.buildSequences();
            this.ghcirc.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    public void stop() {
        try {
            this.ghcirc.stop();
            this.removeAll();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void randomizeSequence(int seqIndex) {
        Vector curSeq = this.sequences[seqIndex];
        int i = 0;
        while (i < curSeq.size()) {
            double[] dar = (double[])curSeq.elementAt(i);
            int k = 0;
            while (k < dar.length) {
                dar[k] = Math.random();
                ++k;
            }
            ++i;
        }
    }

    void buildSequences() {
        this.sequences = new Vector[this.numSources];
        int numParam = this.ghcirc.getNumParameters();
        int i = 0;
        while (i < this.numSources) {
            Vector<double[]> curSeq;
            this.sequences[i] = curSeq = new Vector<double[]>();
            int k = 0;
            while (k < 8) {
                double[] dar = new double[numParam];
                curSeq.addElement(dar);
                ++k;
            }
            this.randomizeSequence(i);
            ++i;
        }
    }

    Panel makeSourceGrid() {
        Panel cbPanel = new Panel();
        cbPanel.setLayout(new GridLayout(0, 1));
        CheckboxGroup cbg = new CheckboxGroup();
        this.sourceBoxes = new Checkbox[this.numSources];
        int i = 0;
        while (i < this.numSources) {
            this.sourceBoxes[i] = new Checkbox(BerlinerSamples.names[i], cbg, i == 0);
            cbPanel.add(this.sourceBoxes[i]);
            ++i;
        }
        return cbPanel;
    }

    Panel makePresetGrid(String name, int numSources) {
        Panel myPanel = new Panel();
        myPanel.add(new Label(name));
        CheckboxGroup cbg = new CheckboxGroup();
        this.presetBoxes = new Checkbox[8];
        int i = 0;
        while (i < 8) {
            this.presetBoxes[i] = new Checkbox(Integer.toString(i), cbg, i == 0);
            myPanel.add(this.presetBoxes[i]);
            ++i;
        }
        return myPanel;
    }

    @Override
    public void tweak(int targetIndex, double val) {
        try {
            switch (targetIndex) {
                case 0: {
                    this.ghcirc.amplitude.set(val);
                    break;
                }
                case 1: {
                    this.ghcirc.setGlideRate(this.amplitudeToGlide(val));
                    break;
                }
                default: {
                    this.ghcirc.setParameter(targetIndex - 2, val);
                    break;
                }
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    double amplitudeToGlide(double amplitude) {
        return amplitude * amplitude * amplitude * amplitude * 0.499 + 0.001;
    }

    public void receiveGlide(double glideRate) {
        try {
            this.ghcirc.setGlideRate(glideRate);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.glideFader.setValue(glideRate);
        this.repaint();
        this.getToolkit().sync();
    }

    void setSource(int source) throws SynthException {
        this.sourceIndex = source;
        this.ghcirc.setSource(source);
    }

    void setPreset(int preset) throws SynthException {
        Vector curSeq = this.sequences[this.sourceIndex];
        double[] dar = (double[])curSeq.elementAt(preset);
        int k = 0;
        while (k < dar.length) {
            this.ghcirc.setParameter(k, dar[k]);
            this.faders[k].setValue(dar[k]);
            ++k;
        }
        this.repaint();
        this.getToolkit().sync();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean action(Event evt, Object what) {
        try {
            if (evt.target == this.debugButton) {
                ((SampleWaveShaper)this.ghcirc).debug();
            }
            int i = 0;
            while (i < this.sourceBoxes.length) {
                if (evt.target == this.sourceBoxes[i]) {
                    this.setSource(i);
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.presetBoxes.length) {
                if (evt.target == this.presetBoxes[i]) {
                    this.setPreset(i);
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        return false;
    }
}

