/*
 * Decompiled with CFR 0.152.
 */
package keyplay;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import keyplay.FilteredImpulse;
import keyplay.FilteredSawEnv;

public class KeyPlay1
extends Applet
implements KeyListener {
    RedNoise redNoise;
    FilteredSawEnv fse;
    FilteredImpulse fimp;
    SynthMixer mixer;
    LineOut lineOut;
    static double freq = 440.0;
    int lastKeyDown = -1;

    public static void main(String[] args) {
        KeyPlay1 applet = new KeyPlay1();
        AppletFrame frame = new AppletFrame("Play ASCII keyboard.", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.fse = new FilteredSawEnv();
            this.fimp = new FilteredImpulse();
            this.redNoise = new RedNoise();
            this.mixer = new SynthMixer(4, 2);
            this.lineOut = new LineOut();
            this.redNoise.amplitude.set(0.0);
            this.mixer.connectInput(0, this.fse.output, 0);
            this.mixer.setGain(0, 0, 0.3);
            this.mixer.setGain(0, 1, 0.3);
            this.mixer.connectInput(1, this.redNoise.output, 0);
            this.mixer.setGain(1, 0, 0.5);
            this.mixer.setGain(1, 1, 0.1);
            this.mixer.connectInput(2, this.fimp.output, 0);
            this.mixer.setGain(2, 0, 0.3);
            this.mixer.setGain(2, 1, 0.9);
            this.mixer.connectOutput(0, this.lineOut.input, 0);
            this.mixer.connectOutput(1, this.lineOut.input, 1);
            this.fse.start();
            this.fimp.start();
            this.redNoise.start();
            this.mixer.start();
            this.lineOut.start();
            this.fse.attack();
            this.addKeyListener(this);
            this.add(new Label("Q,W,E = random freq patterns"));
            this.add(new Label("R,T,Y = on,off,loop amplitude env"));
            this.add(new Label("U,I,O = play noise"));
            this.add(new Label("A,S,D = queue cutoff envelope loops"));
            this.add(new Label("F,G,H,J,K = on,off,4,8,16"));
            this.add(new Label("Z,X,C = change envelope rate"));
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        this.lineOut.delete();
        this.lineOut = null;
        this.fse.delete();
        this.fse = null;
        Synth.verbosity = 0;
        Synth.stopEngine();
    }

    void randomFreqPattern(int numNotes, double dur, double span) {
        int time = Synth.getTickCount();
        int durTicks = (int)(dur * Synth.getTickRate());
        int i = 0;
        while (i < numNotes) {
            if ((freq += Math.random() * 2.0 * span - span) < 80.0) {
                freq = 100.0;
            } else if (freq > 1000.0) {
                freq = 800.0;
            }
            this.fse.frequency.set(time, freq);
            time += durTicks;
            ++i;
        }
    }

    void startNoise(double freq) {
        this.redNoise.frequency.set(freq);
        this.redNoise.amplitude.set(0.4);
    }

    void stopNoise() {
        this.redNoise.amplitude.set(0.0);
    }

    void impulseRiff(double freq) {
        this.fimp.frequency.set(freq);
        this.fimp.setStage(Synth.getTickCount(), 0);
    }

    public void handleKeyDown(int key) {
        int time = Synth.getTickCount();
        switch (key) {
            case 97: {
                this.fse.setStage(time, 0);
                break;
            }
            case 115: {
                this.fse.setStage(time, 1);
                break;
            }
            case 100: {
                this.fse.setStage(time, 2);
                break;
            }
            case 122: {
                this.fse.rate.set(0.5);
                break;
            }
            case 120: {
                this.fse.rate.set(1.0);
                break;
            }
            case 99: {
                this.fse.rate.set(2.0);
                break;
            }
            case 113: {
                this.randomFreqPattern(8, 0.1, 100.0);
                break;
            }
            case 119: {
                this.randomFreqPattern(8, 0.2, 200.0);
                break;
            }
            case 101: {
                this.randomFreqPattern(32, 0.02, 10.0);
                break;
            }
            case 114: {
                this.fse.attack();
                break;
            }
            case 116: {
                this.fse.release();
                break;
            }
            case 121: {
                this.fse.loop();
                break;
            }
            case 117: {
                this.startNoise(200.0);
                break;
            }
            case 105: {
                this.startNoise(600.0);
                break;
            }
            case 111: {
                this.startNoise(2000.0);
                break;
            }
            case 102: {
                this.fimp.setStage(Synth.getTickCount(), 0);
                break;
            }
            case 103: {
                this.fimp.setStage(Synth.getTickCount(), 1);
                break;
            }
            case 104: {
                this.fimp.frequency.set(4.0);
                break;
            }
            case 106: {
                this.fimp.frequency.set(8.0);
                break;
            }
            case 107: {
                this.fimp.frequency.set(16.0);
            }
        }
    }

    public void handleKeyUp(int key) {
        switch (key) {
            case 117: {
                this.stopNoise();
                break;
            }
            case 105: {
                this.stopNoise();
                break;
            }
            case 111: {
                this.stopNoise();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key != this.lastKeyDown) {
            this.lastKeyDown = key;
            this.handleKeyDown(key);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        if (key >= 65 && key <= 122) {
            key += 32;
        }
        this.lastKeyDown = -1;
        this.handleKeyUp(key);
    }
}

