/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.WaveShaper;

public class WaveShapingOscillator
extends SynthNote {
    SineOscillator unitOsc;
    EnvelopePlayer rangeEnvPlayer;
    EnvelopePlayer ampEnvPlayer;
    SynthEnvelope rangeEnvelope;
    SynthEnvelope ampEnvelope;
    WaveShaper unitWaveShaper = new WaveShaper();
    public SynthInput range;

    public WaveShapingOscillator(SynthTable table) throws SynthException {
        this.add(this.unitWaveShaper);
        this.unitOsc = new SineOscillator();
        this.add(this.unitOsc);
        this.rangeEnvPlayer = new EnvelopePlayer();
        this.add(this.rangeEnvPlayer);
        this.ampEnvPlayer = new EnvelopePlayer();
        this.add(this.ampEnvPlayer);
        this.unitWaveShaper.tablePort.setTable(table);
        double[] rangeData = new double[]{0.02, 1.0, 0.2, 0.7, 0.2, 0.9, 2.0, 0.01};
        this.rangeEnvelope = new SynthEnvelope(rangeData);
        this.rangeEnvelope.setSustainLoop(2, 4);
        double[] ampData = new double[]{0.02, 0.9, 0.1, 0.5, 0.5, 0.0};
        this.ampEnvelope = new SynthEnvelope(ampData);
        this.ampEnvelope.setSustainLoop(1, 1);
        this.frequency = this.unitOsc.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.ampEnvPlayer.amplitude;
        this.addPort(this.amplitude);
        this.output = this.unitWaveShaper.output;
        this.addPort(this.output);
        this.range = this.rangeEnvPlayer.amplitude;
        this.addPort(this.range);
        this.rangeEnvPlayer.output.connect(this.unitOsc.amplitude);
        this.ampEnvPlayer.output.connect(this.unitWaveShaper.amplitude);
        this.unitOsc.output.connect(this.unitWaveShaper.input);
        this.frequency.setup(0.0, 200.0, 800.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
        this.range.setup(0.0, 1.0, 1.0);
    }

    public void setRangeEnvelope(SynthEnvelope rangeEnvelope) {
        this.rangeEnvelope = rangeEnvelope;
    }

    public void setAmplitudeEnvelope(SynthEnvelope ampEnvelope) {
        this.ampEnvelope = ampEnvelope;
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                this.rangeEnvPlayer.envelopePort.clear(time);
                this.ampEnvPlayer.envelopePort.clear(time);
                this.rangeEnvPlayer.envelopePort.queueOn(time, this.rangeEnvelope);
                this.ampEnvPlayer.envelopePort.queueOn(time, this.ampEnvelope);
                this.start(time);
                break;
            }
            case 1: {
                this.rangeEnvPlayer.envelopePort.queueOff(time, this.rangeEnvelope);
                this.ampEnvPlayer.envelopePort.queueOff(time, this.ampEnvelope, true);
            }
        }
    }
}

