/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;

public class SineNote
extends SynthNote {
    SineOscillator osc;
    public EnvelopePlayer envPlayer;
    public SynthEnvelope envelope;

    public SineNote(SynthEnvelope env) throws SynthException {
        this.envelope = env;
        this.osc = new SineOscillator();
        this.add(this.osc);
        this.envPlayer = new EnvelopePlayer();
        this.add(this.envPlayer);
        this.envPlayer.output.connect(this.osc.amplitude);
        this.frequency = this.osc.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.envPlayer.amplitude;
        this.addPort(this.amplitude);
        this.output = this.osc.output;
        this.addPort(this.output);
        this.amplitude.setup(0.0, 0.3, 1.0);
        this.frequency.setup(0.0, 160.0, 2000.0);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                this.envPlayer.envelopePort.clear(time);
                this.envPlayer.envelopePort.queue(time, this.envelope, 0, this.envelope.getNumFrames() - 1);
                this.start(time);
                break;
            }
            case 1: {
                this.envPlayer.envelopePort.queue(time, this.envelope, this.envelope.getNumFrames() - 1, 1, 16);
            }
        }
    }
}

