/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class SampleOverview
extends Canvas {
    short[] data;
    int leftIndex = 0;
    int rightIndex = 512;
    int cursorIndex = 0;
    int maxIndex;
    private Graphics buffer;
    private Image image;
    private Rectangle oldRect = new Rectangle(0, 0, 0, 0);
    boolean dataChanged = true;

    public void setLeftIndex(int left) {
        this.leftIndex = left < 0 ? 0 : left;
        this.repaint();
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public void setCursorIndex(int cursorIndex) {
        this.cursorIndex = cursorIndex < 0 ? 0 : cursorIndex;
        this.updateDisplay();
    }

    public int getCursorIndex() {
        return this.cursorIndex;
    }

    private void updateDisplay() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.drawSampleOutline(g);
        }
    }

    public void setRightIndex(int right) {
        this.rightIndex = right > this.maxIndex ? this.maxIndex : right;
        this.repaint();
    }

    public int getRightIndex() {
        return this.leftIndex;
    }

    public void panLeft(int delta) {
        if (this.leftIndex - delta < 0) {
            delta = this.leftIndex;
        }
        this.leftIndex -= delta;
        this.rightIndex -= delta;
        this.repaint();
    }

    public void panLeft() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        this.panLeft(delta);
    }

    public void panRight(int delta) {
        if (this.rightIndex + delta > this.maxIndex) {
            delta = this.maxIndex - this.rightIndex;
        }
        this.leftIndex += delta;
        this.rightIndex += delta;
        this.repaint();
    }

    public void panRight() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        this.panRight(delta);
    }

    public void zoomIn() {
        int delta = (this.rightIndex - this.leftIndex) / 4;
        this.leftIndex += delta;
        this.rightIndex -= delta;
        this.repaint();
    }

    void clipIndices() {
        if (this.rightIndex > this.maxIndex) {
            this.rightIndex = this.maxIndex;
        }
        if (this.leftIndex > this.rightIndex) {
            this.leftIndex = this.rightIndex - 1;
        }
        if (this.leftIndex < 0) {
            this.leftIndex = 0;
        }
    }

    public void zoomOut() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        if (delta < 1) {
            delta = 1;
        }
        this.leftIndex -= delta;
        this.rightIndex += delta;
        this.clipIndices();
        this.repaint();
    }

    public synchronized void setData(short[] data) {
        this.data = data;
        this.leftIndex = 0;
        this.rightIndex = data.length - 1;
        this.dataChanged = true;
    }

    public short[] getData() {
        return this.data;
    }

    private int shortToY(int s, int h) {
        return h * (32768 - s) >> 16;
    }

    @Override
    public void paint(Graphics g) {
        this.drawSampleOutline(g);
    }

    public void drawSampleOutline(Graphics g) {
        if (this.data == null) {
            return;
        }
        int width = this.bounds().width;
        int height = this.bounds().height;
        if (this.oldRect.width != width || this.oldRect.height != height || this.dataChanged) {
            this.image = this.createImage(this.bounds().width, this.bounds().height);
            this.buffer = this.image.getGraphics();
            this.oldRect = this.bounds();
            this.render(this.buffer);
            this.dataChanged = false;
        }
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
            int gx = width * (this.cursorIndex - this.leftIndex) / (this.rightIndex - this.leftIndex);
            if (gx >= 0 && gx < width) {
                g.setXORMode(Color.white);
                g.drawLine(gx, 0, gx, height);
                g.setPaintMode();
            }
        }
    }

    void render(Graphics g) {
        int w = this.size().width;
        int h = this.size().height;
        g.setColor(this.getForeground());
        int startIndex = this.leftIndex;
        int i = 0;
        while (i < w - 1) {
            int endIndex = this.leftIndex + (i + 1) * (this.rightIndex - this.leftIndex) / w;
            short smax = 0;
            short smin = 0;
            int j = startIndex;
            while (j < endIndex) {
                short val = this.data[j];
                if (val < smin) {
                    smin = val;
                } else if (val > smax) {
                    smax = val;
                }
                ++j;
            }
            int y1 = this.shortToY(smin, h);
            int y2 = this.shortToY(smax, h);
            g.drawLine(i, y1, i, y2);
            startIndex = endIndex;
            ++i;
        }
    }
}

