/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class MonoKeyPlayer
implements KeyListener {
    SynthNote synth;
    int lastNoteKey = 97;
    static String keyboard = "zxcvbnmasdfghjqwertyu1234567";
    int lastKeyDown = -1;

    double convertIndexToFreq(int index) {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] scale = nArray;
        int octave = index / scale.length;
        int idx = index % scale.length;
        int pitch = octave * 12 + scale[idx];
        return EqualTemperedTuning.getMIDIFrequency(pitch + 48);
    }

    boolean startNoteByKey(int key) throws SynthException {
        int index = keyboard.indexOf(key);
        if (index < 0) {
            return false;
        }
        double freq = this.convertIndexToFreq(index);
        this.synth.noteOn(Synth.getTickCount(), freq, 0.5);
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key != this.lastKeyDown) {
            this.lastKeyDown = key;
            if (this.startNoteByKey(key)) {
                this.lastNoteKey = key;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == this.lastKeyDown) {
            this.lastKeyDown = -1;
            this.synth.noteOff(Synth.getTickCount());
        }
    }
}

