/*
 * Decompiled with CFR 0.152.
 */
package compmus;

class FFT {
    FFT() {
    }

    public static void complexToComplex(int sign, int n, double[] ar, double[] ai) {
        int j;
        double scale = Math.sqrt(1.0 / (double)n);
        int numb = FFT.numBits(n);
        int i = 0;
        while (i < n) {
            j = FFT.reverseBits(i, numb);
            if (j >= i) {
                double tempr = ar[j] * scale;
                double tempi = ai[j] * scale;
                ar[j] = ar[i] * scale;
                ai[j] = ai[i] * scale;
                ar[i] = tempr;
                ai[i] = tempi;
            }
            ++i;
        }
        int mmax = 1;
        int istep = 2 * mmax;
        while (mmax < n) {
            double delta = (double)sign * Math.PI / (double)mmax;
            int m = 0;
            while (m < mmax) {
                double w = (double)m * delta;
                double wr = Math.cos(w);
                double wi = Math.sin(w);
                i = m;
                while (i < n) {
                    j = i + mmax;
                    double tr = wr * ar[j] - wi * ai[j];
                    double ti = wr * ai[j] + wi * ar[j];
                    ar[j] = ar[i] - tr;
                    ai[j] = ai[i] - ti;
                    int n2 = i;
                    ar[n2] = ar[n2] + tr;
                    int n3 = i;
                    ai[n3] = ai[n3] + ti;
                    i += istep;
                }
                ++m;
            }
            mmax = istep;
            mmax = istep;
            istep = 2 * mmax;
        }
    }

    public static int reverseBits(int index, int numBits) {
        int rev = 0;
        int i = 0;
        while (i < numBits) {
            rev = rev << 1 | index & 1;
            index >>= 1;
            ++i;
        }
        return rev;
    }

    public static int numBits(int powerOf2) {
        int i = -1;
        while (powerOf2 > 0) {
            powerOf2 >>= 1;
            ++i;
        }
        return i;
    }
}

