/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TableOscillator;
import com.softsynth.jsyn.util.HarmonicTable;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class BuildSawUsingSines
extends Applet {
    LineOut lineOut;
    HarmonicTable harmonicTable;
    TableOscillator tableOsc;
    SynthScope scope;
    Button addButton;
    Button subButton;
    Label harmonicLabel;
    int numPartials = 1;
    static final int WAVE_LENGTH = 512;
    static final int MAX_PARTIALS = 60;

    public static void main(String[] args) {
        BuildSawUsingSines applet = new BuildSawUsingSines();
        AppletFrame frame = new AppletFrame("Build Sawtooth", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.requestVersion(141);
            Synth.startEngine(0);
            this.tableOsc = new TableOscillator();
            this.lineOut = new LineOut();
            this.tableOsc.output.connect(0, this.lineOut.input, 0);
            this.tableOsc.output.connect(0, this.lineOut.input, 1);
            Panel buttonPanel = new Panel();
            this.addButton = new Button("Add Harmonic");
            buttonPanel.add(this.addButton);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BuildSawUsingSines.this.numPartials < 60) {
                        ++BuildSawUsingSines.this.numPartials;
                        BuildSawUsingSines.this.buildSawtooth(BuildSawUsingSines.this.numPartials);
                    }
                }
            });
            this.subButton = new Button("Subtract Harmonic");
            buttonPanel.add(this.subButton);
            this.subButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BuildSawUsingSines.this.numPartials > 1) {
                        --BuildSawUsingSines.this.numPartials;
                        BuildSawUsingSines.this.buildSawtooth(BuildSawUsingSines.this.numPartials);
                    }
                }
            });
            this.harmonicLabel = new Label("## harmonics    ");
            buttonPanel.add(this.harmonicLabel);
            this.add("North", buttonPanel);
            Panel faderPanel = new Panel();
            faderPanel.setLayout(new GridLayout(0, 1));
            faderPanel.add(new ExponentialPortFader(this.tableOsc.amplitude, 0.4, 0.001, 1.0));
            faderPanel.add(new ExponentialPortFader(this.tableOsc.frequency, 160.0, 40.0, 5000.0));
            this.add("South", faderPanel);
            this.scope = new SynthScope();
            this.scope.hideControls();
            this.scope.createProbe(this.tableOsc.output, "Output", Color.yellow);
            this.scope.finish();
            this.add("Center", this.scope);
            this.buildSawtooth(1);
            this.lineOut.start();
            this.tableOsc.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void buildSawtooth(int numPartials) {
        this.harmonicLabel.setText(String.valueOf(numPartials) + " harmonic" + (numPartials > 1 ? "s " : " "));
        this.harmonicTable = new HarmonicTable(513, numPartials);
        this.harmonicTable.sawtooth();
        this.tableOsc.tablePort.setTable(this.harmonicTable);
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

