/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.WhiteNoise;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.Tweakable;
import com.softsynth.math.AudioMath;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;

public class AmplitudeVersusDecibels
extends Applet
implements Tweakable {
    WhiteNoise noise;
    LineOut lineOut;
    LabelledFader decibelFader;
    LabelledFader amplitudeFader;
    boolean blockRecursion = false;

    public static void main(String[] args) {
        AmplitudeVersusDecibels applet = new AmplitudeVersusDecibels();
        AppletFrame frame = new AppletFrame("Amplitude Versus Decibels", applet);
        frame.resize(600, 120);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.noise = new WhiteNoise();
            this.lineOut = new LineOut();
            this.noise.output.connect(0, this.lineOut.input, 0);
            this.noise.output.connect(0, this.lineOut.input, 1);
            double minAmp = 0.001;
            double minDB = AudioMath.amplitudeToDecibels(minAmp);
            this.amplitudeFader = new LabelledFader(this, 1, "Amplitude", minAmp, minAmp, 1.0);
            this.add(this.amplitudeFader);
            this.decibelFader = new LabelledFader(this, 2, "Decibels (DB)", minDB, minDB, 0.0);
            this.add(this.decibelFader);
            this.noise.amplitude.set(minAmp);
            this.getParent().validate();
            this.getToolkit().sync();
            this.noise.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.noise.delete();
            this.lineOut.delete();
            this.removeAll();
            System.out.println("Amp vs DB: stopping engine");
            Synth.stopEngine();
            System.out.println("Amp vs DB: stopped");
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    @Override
    public void tweak(int targetIndex, double val) {
        if (this.blockRecursion) {
            return;
        }
        this.blockRecursion = true;
        switch (targetIndex) {
            case 1: {
                this.noise.amplitude.set(val);
                double db = AudioMath.amplitudeToDecibels(val);
                this.decibelFader.setValue(db);
                break;
            }
            case 2: {
                double amp = AudioMath.decibelsToAmplitude(val);
                this.noise.amplitude.set(amp);
                this.amplitudeFader.setValue(amp);
            }
        }
        this.blockRecursion = false;
    }
}

